/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.common.internal.commands.RefreshOnCommand;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.platform.DevicePoPUtils;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.java.providers.oauth2.IAuthorizationStrategy;
import com.microsoft.identity.common.java.providers.oauth2.IResult;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.ResultUtil;
import com.microsoft.identity.common.java.util.ThreadUtils;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class LocalMSALController
extends BaseController {
    private static final String TAG = LocalMSALController.class.getSimpleName();
    private IAuthorizationStrategy mAuthorizationStrategy = null;
    private AuthorizationRequest mAuthorizationRequest = null;

    public AcquireTokenResult acquireToken(@NonNull InteractiveTokenCommandParameters parameters) throws ExecutionException, InterruptedException, ClientException, IOException, ArgumentException {
        String methodTag = TAG + ":acquireToken";
        Logger.verbose(methodTag, "Acquiring token...");
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((CommandParameters)parameters).putApiId("101"));
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        parameters.validate();
        Set mergedScopes = this.addDefaultScopes((TokenCommandParameters)parameters);
        InteractiveTokenCommandParameters parametersWithScopes = ((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        this.logParameters(TAG, parametersWithScopes);
        parametersWithScopes.getPlatformComponents().getPlatformUtil().throwIfNetworkNotAvailable(parametersWithScopes.isPowerOptCheckEnabled());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult((Authority)parametersWithScopes.getAuthority());
        if (!authorityResult.getKnown()) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)authorityResult.getClientException())).putApiId("101"));
            throw authorityResult.getClientException();
        }
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).authenticationScheme(parameters.getAuthenticationScheme()).build();
        OAuth2Strategy oAuth2Strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
        AuthorizationResult result = this.performAuthorizationRequest(oAuth2Strategy, parametersWithScopes);
        acquireTokenResult.setAuthorizationResult(result);
        ResultUtil.logResult((String)TAG, (IResult)result);
        if (result.getAuthorizationStatus().equals((Object)AuthorizationStatus.SUCCESS)) {
            TokenResult tokenResult = this.performTokenRequest(oAuth2Strategy, this.mAuthorizationRequest, result.getAuthorizationResponse(), parametersWithScopes);
            acquireTokenResult.setTokenResult(tokenResult);
            if (tokenResult != null && tokenResult.getSuccess()) {
                List records = this.saveTokens(oAuth2Strategy, this.mAuthorizationRequest, tokenResult.getTokenResponse(), parametersWithScopes.getOAuth2TokenCache());
                ICacheRecord newestRecord = (ICacheRecord)records.get(0);
                acquireTokenResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(this.finalizeCacheRecordForResult(newestRecord, parametersWithScopes.getAuthenticationScheme()), records, SdkType.MSAL, false));
            }
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(acquireTokenResult).putApiId("101"));
        return acquireTokenResult;
    }

    private AuthorizationResult performAuthorizationRequest(@NonNull OAuth2Strategy strategy, @NonNull InteractiveTokenCommandParameters parameters) throws ExecutionException, InterruptedException, ClientException {
        parameters.getPlatformComponents().getPlatformUtil().throwIfNetworkNotAvailable(parameters.isPowerOptCheckEnabled());
        this.mAuthorizationStrategy = parameters.getPlatformComponents().getAuthorizationStrategyFactory().getAuthorizationStrategy(parameters);
        this.mAuthorizationRequest = this.getAuthorizationRequest(strategy, (TokenCommandParameters)parameters);
        Future future = strategy.requestAuthorization(this.mAuthorizationRequest, this.mAuthorizationStrategy);
        return (AuthorizationResult)future.get();
    }

    public void onFinishAuthorizationSession(int requestCode, int resultCode, @NonNull PropertyBag data) {
        String methodTag = TAG + ":onFinishAuthorizationSession";
        Logger.verbose(methodTag, "Completing authorization...");
        Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("1032").put("Microsoft.MSAL.result_code", String.valueOf(resultCode)).put("Microsoft.MSAL.request_code", String.valueOf(requestCode)));
        this.mAuthorizationStrategy.completeAuthorization(requestCode, RawAuthorizationResult.fromPropertyBag((PropertyBag)data));
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("1032"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public AcquireTokenResult acquireTokenSilent(@NonNull SilentTokenCommandParameters parameters) throws IOException, ClientException, ArgumentException, ServiceException {
        String methodTag = TAG + ":acquireTokenSilent";
        Logger.verbose(methodTag, "Acquiring token silently...");
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((CommandParameters)parameters).putApiId("103"));
        AcquireTokenResult acquireTokenSilentResult = new AcquireTokenResult();
        parameters.validate();
        Set mergedScopes = this.addDefaultScopes((TokenCommandParameters)parameters);
        SilentTokenCommandParameters parametersWithScopes = ((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        OAuth2TokenCache tokenCache = parametersWithScopes.getOAuth2TokenCache();
        AccountRecord targetAccount = this.getCachedAccountRecord(parametersWithScopes);
        AbstractAuthenticationScheme authScheme = parametersWithScopes.getAuthenticationScheme();
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).authenticationScheme(authScheme).build();
        OAuth2Strategy strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
        List cacheRecords = tokenCache.loadWithAggregatedAccountData(parametersWithScopes.getClientId(), parameters.getApplicationIdentifier(), parameters.getMamEnrollmentId(), TextUtils.join((CharSequence)" ", (Iterable)parametersWithScopes.getScopes()), targetAccount, authScheme);
        ICacheRecord fullCacheRecord = (ICacheRecord)cacheRecords.get(0);
        if (LibraryConfiguration.getInstance().isRefreshInEnabled() && fullCacheRecord.getAccessToken() != null && fullCacheRecord.getAccessToken().refreshOnIsActive()) {
            Logger.info(methodTag, "RefreshOn is active. This will extend your token usage in the rare case servers are not available.");
        }
        if (LibraryConfiguration.getInstance().isRefreshInEnabled() && fullCacheRecord.getAccessToken() != null && fullCacheRecord.getAccessToken().shouldRefresh()) {
            if (!fullCacheRecord.getAccessToken().isExpired()) {
                this.setAcquireTokenResult(acquireTokenSilentResult, parametersWithScopes, cacheRecords);
                RefreshOnCommand refreshOnCommand = new RefreshOnCommand((CommandParameters)parameters, this, "1201");
                CommandDispatcher.submitAndForget((BaseCommand)refreshOnCommand);
            } else {
                Logger.warn(methodTag, "Access token is expired. Removing from cache...");
                tokenCache.removeCredential((Credential)fullCacheRecord.getAccessToken());
                this.renewAT(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord, methodTag);
            }
        } else if (this.accessTokenIsNull(fullCacheRecord) || this.refreshTokenIsNull(fullCacheRecord) || parametersWithScopes.isForceRefresh() || !this.isRequestAuthorityRealmSameAsATRealm(parametersWithScopes.getAuthority(), fullCacheRecord.getAccessToken()) || !strategy.validateCachedResult(authScheme, fullCacheRecord)) {
            if (this.refreshTokenIsNull(fullCacheRecord)) {
                UiRequiredException exception = new UiRequiredException("no_tokens_found", "No refresh token was found. ");
                Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)exception).putApiId("103"));
                throw exception;
            }
            this.renewAT(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord, methodTag);
        } else if (fullCacheRecord.getAccessToken().isExpired()) {
            Logger.warn(methodTag, "Access token is expired. Removing from cache...");
            tokenCache.removeCredential((Credential)fullCacheRecord.getAccessToken());
            this.renewAT(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord, methodTag);
        } else {
            Logger.verbose(methodTag, "Returning silent result");
            this.setAcquireTokenResult(acquireTokenSilentResult, parametersWithScopes, cacheRecords);
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(acquireTokenSilentResult).putApiId("103"));
        return acquireTokenSilentResult;
    }

    private void setAcquireTokenResult(AcquireTokenResult acquireTokenSilentResult, SilentTokenCommandParameters parametersWithScopes, List<ICacheRecord> cacheRecords) throws ClientException {
        ICacheRecord fullCacheRecord = cacheRecords.get(0);
        acquireTokenSilentResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(this.finalizeCacheRecordForResult(fullCacheRecord, parametersWithScopes.getAuthenticationScheme()), cacheRecords, SdkType.MSAL, true));
    }

    private void renewAT(@NonNull SilentTokenCommandParameters parametersWithScopes, @NonNull AcquireTokenResult acquireTokenSilentResult, @NonNull OAuth2TokenCache tokenCache, @NonNull OAuth2Strategy strategy, @NonNull ICacheRecord cacheRecord, @NonNull String tag) throws IOException, ClientException, ServiceException {
        Logger.verbose(tag, "Renewing access token...");
        this.renewAccessToken(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, cacheRecord);
    }

    @WorkerThread
    public List<ICacheRecord> getAccounts(@NonNull CommandParameters parameters) {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties(parameters).putApiId("106"));
        List accountsInCache = parameters.getOAuth2TokenCache().getAccountsWithAggregatedAccountData(null, parameters.getClientId());
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("106").put("Microsoft.MSAL.accounts_number", Integer.toString(accountsInCache.size())).put("_is_successful", "true"));
        return accountsInCache;
    }

    @WorkerThread
    public boolean removeAccount(@NonNull RemoveAccountCommandParameters parameters) {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((CommandParameters)parameters).putApiId("107"));
        String realm = null;
        if (parameters.getAccount() != null) {
            realm = parameters.getAccount().getRealm();
        }
        boolean localRemoveAccountSuccess = !parameters.getOAuth2TokenCache().removeAccount(null, parameters.getClientId(), parameters.getAccount() == null ? null : parameters.getAccount().getHomeAccountId(), realm).isEmpty();
        Telemetry.emit((BaseEvent)new ApiEndEvent().put("_is_successful", String.valueOf(localRemoveAccountSuccess)).putApiId("107"));
        return localRemoveAccountSuccess;
    }

    public boolean getDeviceMode(CommandParameters parameters) throws Exception {
        String methodTag = TAG + ":getDeviceMode";
        String errorMessage = "LocalMSALController is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.";
        com.microsoft.identity.common.internal.logging.Logger.warn(methodTag, "LocalMSALController is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.");
        return false;
    }

    public List<ICacheRecord> getCurrentAccount(CommandParameters parameters) throws Exception {
        return this.getAccounts(parameters);
    }

    public boolean removeCurrentAccount(RemoveAccountCommandParameters parameters) throws Exception {
        return this.removeAccount(parameters);
    }

    public AuthorizationResult deviceCodeFlowAuthRequest(DeviceCodeFlowCommandParameters parameters) throws ServiceException, ClientException, IOException {
        AuthorizationResult authorizationResult;
        String methodTag = TAG + ":deviceCodeFlowAuthRequest";
        Logger.verbose(methodTag, "Device Code Flow: Authorizing user code...");
        Set mergedScopes = this.addDefaultScopes((TokenCommandParameters)parameters);
        DeviceCodeFlowCommandParameters parametersWithScopes = ((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        this.logParameters(TAG, parametersWithScopes);
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((CommandParameters)parametersWithScopes).putApiId("108"));
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult((Authority)parametersWithScopes.getAuthority());
        if (!authorityResult.getKnown()) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)authorityResult.getClientException())).putApiId("108"));
            throw authorityResult.getClientException();
        }
        try {
            OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).authenticationScheme(parameters.getAuthenticationScheme()).build();
            OAuth2Strategy oAuth2Strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
            this.mAuthorizationRequest = this.getAuthorizationRequest(oAuth2Strategy, (TokenCommandParameters)parametersWithScopes);
            authorizationResult = oAuth2Strategy.getDeviceCode((MicrosoftStsAuthorizationRequest)this.mAuthorizationRequest);
            this.validateServiceResult((IResult)authorizationResult);
        }
        catch (Exception error) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException(error).putApiId("108"));
            throw error;
        }
        Logger.verbose(methodTag, "Device Code Flow authorization step finished...");
        ResultUtil.logResult((String)TAG, (IResult)authorizationResult);
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("108"));
        return authorizationResult;
    }

    public AcquireTokenResult acquireDeviceCodeFlowToken(AuthorizationResult authorizationResult, DeviceCodeFlowCommandParameters parameters) throws ServiceException, ClientException, IOException {
        String methodTag = TAG + ":acquireDeviceCodeFlowToken";
        Logger.verbose(methodTag, "Device Code Flow: Polling for token...");
        Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("109"));
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        acquireTokenResult.setAuthorizationResult(authorizationResult);
        MicrosoftStsAuthorizationResponse authorizationResponse = (MicrosoftStsAuthorizationResponse)authorizationResult.getAuthorizationResponse();
        TokenResult tokenResult = null;
        try {
            OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).authenticationScheme(parameters.getAuthenticationScheme()).build();
            OAuth2Strategy oAuth2Strategy = parameters.getAuthority().createOAuth2Strategy(strategyParameters);
            MicrosoftStsTokenRequest tokenRequest = (MicrosoftStsTokenRequest)oAuth2Strategy.createTokenRequest(this.mAuthorizationRequest, (AuthorizationResponse)authorizationResponse, parameters.getAuthenticationScheme());
            int intervalInMilliseconds = Integer.parseInt(authorizationResponse.getInterval()) * 1000;
            String errorCode = "authorization_pending";
            while (this.authorizationPending(errorCode)) {
                ThreadUtils.sleepSafely((int)intervalInMilliseconds, (String)TAG, (String)"Attempting to sleep thread during Device Code Flow token polling...");
                errorCode = "";
                TokenResult tokenResultFromRequestToken = oAuth2Strategy.requestToken((TokenRequest)tokenRequest);
                tokenResult = tokenResultFromRequestToken;
                if (tokenResult.getErrorResponse() == null) continue;
                errorCode = tokenResult.getErrorResponse().getError();
            }
            this.validateServiceResult((IResult)tokenResult);
            acquireTokenResult.setTokenResult(tokenResult);
            List records = this.saveTokens(oAuth2Strategy, this.mAuthorizationRequest, acquireTokenResult.getTokenResult().getTokenResponse(), parameters.getOAuth2TokenCache());
            ICacheRecord newestRecord = (ICacheRecord)records.get(0);
            acquireTokenResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(this.finalizeCacheRecordForResult(newestRecord, parameters.getAuthenticationScheme()), records, SdkType.MSAL, false));
        }
        catch (Exception error) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException(error).putApiId("109"));
            throw error;
        }
        ResultUtil.logResult((String)TAG, (IResult)tokenResult);
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(acquireTokenResult).putApiId("109"));
        return acquireTokenResult;
    }

    public GenerateShrResult generateSignedHttpRequest(@NonNull GenerateShrCommandParameters parameters) throws Exception {
        GenerateShrResult result;
        OAuth2TokenCache cache = parameters.getOAuth2TokenCache();
        String clientId = parameters.getClientId();
        String homeAccountId = parameters.getHomeAccountId();
        IPoPAuthenticationSchemeParams popSchemeParams = parameters.getPopParameters();
        if (this.userHasLocalAccountRecord(cache, clientId, homeAccountId)) {
            result = DevicePoPUtils.generateSignedHttpRequest((IPlatformComponents)parameters.getPlatformComponents(), (IPoPAuthenticationSchemeParams)popSchemeParams);
        } else {
            result = new GenerateShrResult();
            result.setErrorCode("no_account_found");
            result.setErrorMessage("Account does not exist.");
        }
        return result;
    }

    private boolean userHasLocalAccountRecord(@NonNull OAuth2TokenCache cache, @NonNull String clientId, @NonNull String homeAccountId) {
        return null != cache.getAccountByHomeAccountId(null, clientId, homeAccountId);
    }

    private boolean authorizationPending(@NonNull String errorCode) {
        return errorCode.equals("authorization_pending");
    }

    private void validateServiceResult(@NonNull IResult result) throws ServiceException {
        if (!result.getSuccess()) {
            String errorMessage;
            String errorCode;
            switch (errorCode = result.getErrorResponse().getError()) {
                case "authorization_declined": {
                    errorMessage = "The end user has denied the authorization request. Re-run the Device Code Flow Protocol with another user.";
                    break;
                }
                case "expired_token": {
                    errorMessage = "The token has expired, therefore authentication is no longer possible with this flow attempt. Re-run the Device Code Flow Protocol to try again.";
                    break;
                }
                case "bad_verification_code": {
                    errorMessage = "The token request contains a device code that was not recognized. Verify that the client is sending the right device code.";
                    break;
                }
                case "invalid_grant": {
                    errorMessage = "The token for this device code has already been redeemed. To receive another access token, please re-run the Device Code Flow protocol.";
                    break;
                }
                case "invalid_scope": {
                    errorMessage = "The scope attached to the device code flow request is invalid. Please re-try with a valid scope.";
                    break;
                }
                default: {
                    errorMessage = "Device Code Flow has failed with an unexpected error. The error code shown was received from the result object.";
                }
            }
            throw new ServiceException(errorCode, errorMessage, 0, null);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalMSALController)) {
            return false;
        }
        LocalMSALController other = (LocalMSALController)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalMSALController;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

