/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractNfcSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractUsbSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.DialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICancelCbaCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IConnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDismissCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.NfcSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.OnDeviceCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardCertBasedAuthManagerFactory;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.UsbSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.UserChoiceDialog;
import com.microsoft.identity.common.java.opentelemetry.CertBasedAuthChoice;
import com.microsoft.identity.common.java.opentelemetry.CertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;

public class CertBasedAuthFactory {
    private static final String USER_CANCEL_MESSAGE = "User canceled smartcard CBA flow.";
    private static final String NON_APPLICABLE = "N/A";
    private final Activity mActivity;
    private final AbstractUsbSmartcardCertBasedAuthManager mUsbSmartcardCertBasedAuthManager;
    private final AbstractNfcSmartcardCertBasedAuthManager mNfcSmartcardCertBasedAuthManager;
    private final IDialogHolder mDialogHolder;

    public CertBasedAuthFactory(@NonNull Activity activity) {
        this.mActivity = activity;
        this.mUsbSmartcardCertBasedAuthManager = SmartcardCertBasedAuthManagerFactory.createUsbSmartcardCertBasedAuthManager(this.mActivity.getApplicationContext());
        this.mNfcSmartcardCertBasedAuthManager = SmartcardCertBasedAuthManagerFactory.createNfcSmartcardCertBasedAuthManager(this.mActivity.getApplicationContext());
        this.mDialogHolder = new DialogHolder(this.mActivity);
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.startDiscovery(activity);
        }
    }

    @VisibleForTesting
    protected CertBasedAuthFactory(@NonNull Activity activity, @NonNull AbstractUsbSmartcardCertBasedAuthManager usbManager, @NonNull AbstractNfcSmartcardCertBasedAuthManager nfcManager, @NonNull IDialogHolder dialogHolder) {
        this.mActivity = activity;
        this.mUsbSmartcardCertBasedAuthManager = usbManager;
        this.mNfcSmartcardCertBasedAuthManager = nfcManager;
        this.mDialogHolder = dialogHolder;
    }

    public void createCertBasedAuthChallengeHandler(final @NonNull CertBasedAuthChallengeHandlerCallback callback) {
        CertBasedAuthTelemetryHelper telemetryHelper = new CertBasedAuthTelemetryHelper();
        telemetryHelper.setUserChoice(CertBasedAuthChoice.NON_APPLICABLE);
        telemetryHelper.setCertBasedAuthChallengeHandler(NON_APPLICABLE);
        if (this.mUsbSmartcardCertBasedAuthManager != null && this.mUsbSmartcardCertBasedAuthManager.isDeviceConnected()) {
            telemetryHelper.setUserChoice(CertBasedAuthChoice.SMARTCARD_CHOICE);
            callback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(this.mActivity, this.mUsbSmartcardCertBasedAuthManager, this.mDialogHolder, (ICertBasedAuthTelemetryHelper)telemetryHelper));
            return;
        }
        this.mDialogHolder.showUserChoiceDialog(new UserChoiceDialog.PositiveButtonListener((ICertBasedAuthTelemetryHelper)telemetryHelper, callback){
            final /* synthetic */ ICertBasedAuthTelemetryHelper val$telemetryHelper;
            final /* synthetic */ CertBasedAuthChallengeHandlerCallback val$callback;
            {
                this.val$telemetryHelper = iCertBasedAuthTelemetryHelper;
                this.val$callback = certBasedAuthChallengeHandlerCallback;
            }

            @Override
            @RequiresApi(api=21)
            public void onClick(int checkedPosition) {
                if (checkedPosition == 0) {
                    CertBasedAuthFactory.this.mDialogHolder.dismissDialog();
                    this.val$telemetryHelper.setUserChoice(CertBasedAuthChoice.ON_DEVICE_CHOICE);
                    this.val$callback.onReceived(new OnDeviceCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, this.val$telemetryHelper));
                    return;
                }
                this.val$telemetryHelper.setUserChoice(CertBasedAuthChoice.SMARTCARD_CHOICE);
                CertBasedAuthFactory.this.setUpForSmartcardCertBasedAuth(this.val$callback, this.val$telemetryHelper);
            }
        }, new ICancelCbaCallback((ICertBasedAuthTelemetryHelper)telemetryHelper){
            final /* synthetic */ ICertBasedAuthTelemetryHelper val$telemetryHelper;
            {
                this.val$telemetryHelper = iCertBasedAuthTelemetryHelper;
            }

            @Override
            @RequiresApi(api=21)
            public void onCancel() {
                CertBasedAuthFactory.this.onCancelHelper(callback, this.val$telemetryHelper);
            }
        });
    }

    private void onCancelHelper(@NonNull CertBasedAuthChallengeHandlerCallback callback, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        this.mDialogHolder.dismissDialog();
        telemetryHelper.setResultFailure(USER_CANCEL_MESSAGE);
        this.mNfcSmartcardCertBasedAuthManager.clearConnectionCallback();
        this.mUsbSmartcardCertBasedAuthManager.clearConnectionCallback();
        callback.onReceived(null);
    }

    private void setUpForSmartcardCertBasedAuth(final @NonNull CertBasedAuthChallengeHandlerCallback callback, final @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        if (this.mUsbSmartcardCertBasedAuthManager != null && this.mUsbSmartcardCertBasedAuthManager.isDeviceConnected()) {
            callback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(this.mActivity, this.mUsbSmartcardCertBasedAuthManager, this.mDialogHolder, telemetryHelper));
            return;
        }
        if (this.mNfcSmartcardCertBasedAuthManager != null && this.mNfcSmartcardCertBasedAuthManager.startDiscovery(this.mActivity)) {
            this.mDialogHolder.showSmartcardNfcReminderDialog(new IDismissCallback(){

                @Override
                public void onDismiss() {
                    if (CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager != null && CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager.isDeviceConnected()) {
                        callback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager, CertBasedAuthFactory.this.mDialogHolder, telemetryHelper));
                        return;
                    }
                    CertBasedAuthFactory.this.showSmartcardPromptDialogAndSetConnectionCallback(callback, telemetryHelper);
                }
            });
            return;
        }
        this.showSmartcardPromptDialogAndSetConnectionCallback(callback, telemetryHelper);
    }

    private void showSmartcardPromptDialogAndSetConnectionCallback(final @NonNull CertBasedAuthChallengeHandlerCallback challengeHandlerCallback, final @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        this.mDialogHolder.showSmartcardPromptDialog(new ICancelCbaCallback(){

            @Override
            @RequiresApi(api=21)
            public void onCancel() {
                if (CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager != null) {
                    CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager.stopDiscovery(CertBasedAuthFactory.this.mActivity);
                }
                CertBasedAuthFactory.this.onCancelHelper(challengeHandlerCallback, telemetryHelper);
            }
        });
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.setConnectionCallback(new IConnectionCallback(){

                @Override
                @RequiresApi(api=21)
                public void onCreateConnection() {
                    if (CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager != null) {
                        CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager.stopDiscovery(CertBasedAuthFactory.this.mActivity);
                        CertBasedAuthFactory.this.clearAllSmartcardConnectionAndDisconnectionCallbacks();
                    }
                    challengeHandlerCallback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager, CertBasedAuthFactory.this.mDialogHolder, telemetryHelper));
                }
            });
        }
        if (this.mNfcSmartcardCertBasedAuthManager == null) {
            return;
        }
        this.mNfcSmartcardCertBasedAuthManager.setConnectionCallback(new IConnectionCallback(){

            @Override
            @RequiresApi(api=21)
            public void onCreateConnection() {
                if (CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager != null) {
                    CertBasedAuthFactory.this.clearAllSmartcardConnectionAndDisconnectionCallbacks();
                }
                CertBasedAuthFactory.this.mDialogHolder.showSmartcardNfcLoadingDialog();
                challengeHandlerCallback.onReceived(new NfcSmartcardCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager, CertBasedAuthFactory.this.mDialogHolder, telemetryHelper));
            }
        });
    }

    public void clearAllSmartcardConnectionAndDisconnectionCallbacks() {
        this.mUsbSmartcardCertBasedAuthManager.clearConnectionCallback();
        this.mUsbSmartcardCertBasedAuthManager.clearDisconnectionCallback();
        this.mNfcSmartcardCertBasedAuthManager.clearConnectionCallback();
    }

    public void onDestroy() {
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.onDestroy(this.mActivity);
        }
        if (this.mNfcSmartcardCertBasedAuthManager != null) {
            this.mNfcSmartcardCertBasedAuthManager.onDestroy(this.mActivity);
        }
    }

    public static interface CertBasedAuthChallengeHandlerCallback {
        public void onReceived(@Nullable AbstractCertBasedAuthChallengeHandler var1);
    }
}

