/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.java.util.BrokerProtocolVersionUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BrowserSelector {
    private static final String TAG = BrowserSelector.class.getSimpleName();
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final String LOGGING_MSG_BROWSER = "Browser: ";

    public static Browser select(@NonNull Context context, @NonNull List<BrowserDescriptor> browserSafeList, @Nullable BrowserDescriptor preferredBrowserDescriptor) throws ClientException {
        Browser preferredBrowser;
        String methodTag = TAG + ":select";
        Logger.verbose(methodTag, "Select the browser to launch.");
        if (preferredBrowserDescriptor != null && (preferredBrowser = BrowserSelector.getPreferredBrowser(context, preferredBrowserDescriptor)) != null) {
            return preferredBrowser;
        }
        Browser defaultBrowser = BrowserSelector.getDefaultBrowser(context, browserSafeList);
        if (defaultBrowser != null) {
            return defaultBrowser;
        }
        Logger.error(methodTag, "No available browser installed on the device.", null);
        throw new ClientException("No available browser installed on the device.", "No available browser installed on the device.");
    }

    private static boolean matches(@NonNull BrowserDescriptor descriptor, @NonNull Browser browser) {
        String methodTag = TAG + ":matches";
        if (!StringUtil.equalsIgnoreCase((String)descriptor.getPackageName(), (String)browser.getPackageName())) {
            return false;
        }
        if (!descriptor.getSignatureHashes().equals(browser.getSignatureHashes())) {
            Logger.warn(methodTag, LOGGING_MSG_BROWSER + browser.getPackageName() + " signature hash not match");
            return false;
        }
        if (!StringUtil.isNullOrEmpty((String)descriptor.getVersionLowerBound()) && BrokerProtocolVersionUtil.compareSemanticVersion((String)browser.getVersion(), (String)descriptor.getVersionLowerBound()) == -1) {
            Logger.warn(methodTag, LOGGING_MSG_BROWSER + browser.getPackageName() + " version too low (Expected: " + descriptor.getVersionLowerBound() + " Get: " + browser.getVersion() + ")");
            return false;
        }
        if (!StringUtil.isNullOrEmpty((String)descriptor.getVersionUpperBound()) && BrokerProtocolVersionUtil.compareSemanticVersion((String)browser.getVersion(), (String)descriptor.getVersionUpperBound()) == 1) {
            Logger.warn(methodTag, LOGGING_MSG_BROWSER + browser.getPackageName() + " version too high (Expected: " + descriptor.getVersionUpperBound() + " Get: " + browser.getVersion() + ")");
            return false;
        }
        return true;
    }

    private static Browser getPreferredBrowser(@NonNull Context context, @NonNull BrowserDescriptor preferredBrowserDescriptor) {
        String methodTag = TAG + ":getPreferredBrowser";
        List<Browser> allBrowsers = BrowserSelector.getBrowsers(context, preferredBrowserDescriptor);
        for (Browser browser : allBrowsers) {
            if (!BrowserSelector.matches(preferredBrowserDescriptor, browser)) continue;
            Logger.info(methodTag, "Preferred Browser's package name: " + browser.getPackageName() + " version: " + browser.getVersion());
            return browser;
        }
        return null;
    }

    private static Browser getDefaultBrowser(@NonNull Context context, @NonNull List<BrowserDescriptor> browserSafeList) {
        String methodTag = TAG + ":getDefaultBrowser";
        List<Browser> allBrowsers = BrowserSelector.getBrowsers(context, null);
        for (Browser browser : allBrowsers) {
            for (BrowserDescriptor browserDescriptor : browserSafeList) {
                if (!BrowserSelector.matches(browserDescriptor, browser)) continue;
                Logger.info(methodTag, "Browser's package name: " + browser.getPackageName() + " version: " + browser.getVersion());
                return browser;
            }
        }
        return null;
    }

    protected static List<Browser> getBrowsers(@NonNull Context context, @Nullable BrowserDescriptor preferredBrowserDescriptor) {
        String methodTag = TAG + ":getBrowsers";
        Intent BROWSER_INTENT = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        if (preferredBrowserDescriptor != null) {
            Logger.info(methodTag, "Querying preferred browser: " + preferredBrowserDescriptor.getPackageName());
            BROWSER_INTENT.setPackage(preferredBrowserDescriptor.getPackageName());
        }
        PackageManager pm = context.getPackageManager();
        int queryFlag = 64;
        if (Build.VERSION.SDK_INT >= 23) {
            queryFlag |= 0x10000;
        }
        List resolvedActivityList = pm.queryIntentActivities(BROWSER_INTENT, queryFlag);
        Logger.verbose(methodTag, "Querying browsers. Got back " + resolvedActivityList.size() + " browsers.");
        ArrayList<Browser> browserList = new ArrayList<Browser>();
        for (ResolveInfo info : resolvedActivityList) {
            if (!BrowserSelector.isFullBrowser(info)) {
                Logger.verbose(methodTag, LOGGING_MSG_BROWSER + info.activityInfo.packageName + " is not a full browser app.");
                continue;
            }
            try {
                PackageInfo packageInfo = PackageHelper.getPackageInfo(pm, info.activityInfo.packageName);
                if (BrowserSelector.isCustomTabsServiceSupported(context, packageInfo)) {
                    Logger.verbose(methodTag, LOGGING_MSG_BROWSER + info.activityInfo.packageName + " supports custom tab.");
                    browserList.add(new Browser(packageInfo, true));
                    continue;
                }
                Logger.verbose(methodTag, LOGGING_MSG_BROWSER + info.activityInfo.packageName + " does NOT support custom tab.");
                browserList.add(new Browser(packageInfo, false));
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.warn(methodTag, LOGGING_MSG_BROWSER + info.activityInfo.packageName + " cannot be generated without the package info.");
            }
        }
        Logger.verbose(methodTag, null, "Found " + browserList.size() + " browsers.");
        return browserList;
    }

    private static boolean isCustomTabsServiceSupported(@NonNull Context context, @NonNull PackageInfo packageInfo) {
        Intent serviceIntent = new Intent("android" + ".support.customtabs.action.CustomTabsService");
        serviceIntent.setPackage(packageInfo.packageName);
        List resolveInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
        return resolveInfos != null && !resolveInfos.isEmpty();
    }

    private static boolean isFullBrowser(ResolveInfo resolveInfo) {
        if (!resolveInfo.filter.hasAction("android.intent.action.VIEW") || !resolveInfo.filter.hasCategory("android.intent.category.BROWSABLE") || resolveInfo.filter.schemesIterator() == null) {
            return false;
        }
        if (resolveInfo.filter.authoritiesIterator() != null) {
            return false;
        }
        boolean supportsHttp = false;
        boolean supportsHttps = false;
        Iterator schemeIter = resolveInfo.filter.schemesIterator();
        while (schemeIter.hasNext()) {
            String scheme = (String)schemeIter.next();
            if (!(supportsHttp |= SCHEME_HTTP.equals(scheme)) || !(supportsHttps |= SCHEME_HTTPS.equals(scheme))) continue;
            return true;
        }
        return false;
    }
}

