/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.os.Bundle;
import android.os.IInterface;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.BoundServiceClient;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.logging.Logger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class BoundServiceStrategy<T extends IInterface>
implements IIpcStrategy {
    private static final String TAG = BoundServiceStrategy.class.getSimpleName();
    private final BoundServiceClient<T> mClient;

    public BoundServiceStrategy(@NonNull BoundServiceClient<T> boundServiceClient) {
        this.mClient = boundServiceClient;
    }

    @Override
    @Nullable
    public Bundle communicateToBroker(@NonNull BrokerOperationBundle brokerOperationBundle) throws BrokerCommunicationException {
        String methodTag = TAG + ":communicateToBroker";
        String operationName = brokerOperationBundle.getOperation().name();
        Logger.info(methodTag, "Broker operation: " + operationName + " brokerPackage: " + brokerOperationBundle.getTargetBrokerAppPackageName());
        try {
            Bundle bundle = this.mClient.performOperation(brokerOperationBundle);
            return bundle;
        }
        catch (RemoteException | InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
            String errorDescription = "Error occurred while awaiting (get) return of bound Service with " + this.mClient.getClass().getSimpleName();
            Logger.error(methodTag, errorDescription, e);
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.CONNECTION_ERROR, this.getType(), errorDescription, e);
        }
        finally {
            this.mClient.disconnect();
        }
    }

    @Override
    public IIpcStrategy.Type getType() {
        return IIpcStrategy.Type.BOUND_SERVICE;
    }
}

