/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import com.microsoft.identity.common.PropertyBagUtil;
import com.microsoft.identity.common.internal.broker.IInstallCertCallback;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.LocalBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;

public final class InstallCertActivityLauncher
extends AppCompatActivity {
    private static final String TAG = InstallCertActivityLauncher.class.getSimpleName();
    private static final String INSTALL_CERT_INTENT_STARTED = "broker_intent_started";
    private static final String INSTALL_CERT_INTENT = "install_cert_intent";
    private static final String INSTALL_CERT_BROADCAST_ALIAS = "install_cert_broadcast_alias";
    private static final String CERT_INSTALLATION_FAILED_WITH_EMPTY_RESPONSE = "Certificate installation failed with an empty response";
    private Intent mInstallCertificateIntent;
    private Boolean mInstallCertificateIntentStarted = false;
    private Boolean mInstallCertificateResultReceived = false;
    final ActivityResultLauncher<Intent> installCertActivityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), activityResult -> {
        PropertyBag resultBag;
        String methodTag = TAG + "#installCertActivityResultLauncher";
        Logger.info(methodTag, "Result received from Broker, Result code: " + activityResult.getResultCode());
        Intent intentWithData = activityResult.getData();
        if (intentWithData == null || intentWithData.getExtras() == null) {
            Logger.error(methodTag, CERT_INSTALLATION_FAILED_WITH_EMPTY_RESPONSE, null);
            resultBag = new PropertyBag();
        } else {
            resultBag = PropertyBagUtil.fromBundle(intentWithData.getExtras());
        }
        this.mInstallCertificateResultReceived = true;
        LocalBroadcaster.INSTANCE.broadcast(INSTALL_CERT_BROADCAST_ALIAS, resultBag);
        this.finish();
    });

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.mInstallCertificateIntent = (Intent)this.getIntent().getExtras().getParcelable(INSTALL_CERT_INTENT);
        } else {
            this.mInstallCertificateIntent = (Intent)savedInstanceState.getParcelable(INSTALL_CERT_INTENT);
            this.mInstallCertificateIntentStarted = savedInstanceState.getBoolean(INSTALL_CERT_INTENT_STARTED);
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.mInstallCertificateIntentStarted.booleanValue()) {
            this.mInstallCertificateIntentStarted = true;
            this.installCertActivityResultLauncher.launch((Object)this.mInstallCertificateIntent);
        }
    }

    protected void onDestroy() {
        if (!this.mInstallCertificateResultReceived.booleanValue()) {
            Logger.error(TAG, "The activity is killed unexpectedly.", null);
            LocalBroadcaster.INSTANCE.broadcast(INSTALL_CERT_BROADCAST_ALIAS, new PropertyBag());
        }
        super.onDestroy();
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(INSTALL_CERT_INTENT, (Parcelable)this.mInstallCertificateIntent);
        outState.putBoolean(INSTALL_CERT_INTENT_STARTED, this.mInstallCertificateIntentStarted.booleanValue());
    }

    public static void installCertificate(@NonNull Activity activity, @NonNull Intent installCertificateIntent, @NonNull IInstallCertCallback callback, @NonNull String keyToExtractResult, @NonNull String keyToExtractError) {
        Intent installCertLauncher = new Intent((Context)activity, InstallCertActivityLauncher.class);
        installCertLauncher.putExtra(INSTALL_CERT_INTENT, (Parcelable)installCertificateIntent);
        InstallCertActivityLauncher.registerCallbackAndParseResult(callback, keyToExtractResult, keyToExtractError);
        activity.startActivity(installCertLauncher);
    }

    private static void registerCallbackAndParseResult(@NonNull IInstallCertCallback callback, @NonNull String keyToExtractResult, @NonNull String keyToExtractError) {
        LocalBroadcaster.INSTANCE.registerCallback(INSTALL_CERT_BROADCAST_ALIAS, propertyBag -> {
            String isCertInstalled = (String)((Object)propertyBag.get(keyToExtractResult));
            String exceptionMessage = (String)((Object)propertyBag.get(keyToExtractError));
            if (StringUtil.isNullOrEmpty((String)exceptionMessage) && !StringUtil.isNullOrEmpty((String)isCertInstalled)) {
                callback.onSuccess(Boolean.parseBoolean(isCertInstalled));
            } else {
                String errorMessage = StringUtil.isNullOrEmpty((String)exceptionMessage) ? CERT_INSTALLATION_FAILED_WITH_EMPTY_RESPONSE : exceptionMessage;
                callback.onError((BaseException)new ClientException("unknown_error", errorMessage));
            }
            LocalBroadcaster.INSTANCE.unregisterCallback(INSTALL_CERT_BROADCAST_ALIAS);
        });
    }
}

