/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.security.KeyChain;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertBasedAuthChallengeHandler;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.logging.Logger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class OnDeviceCertBasedAuthChallengeHandler
implements ICertBasedAuthChallengeHandler {
    private static final String TAG = OnDeviceCertBasedAuthChallengeHandler.class.getSimpleName();
    private static final String ACCEPTABLE_ISSUER = "CN=MS-Organization-Access";
    private final Activity mActivity;
    private final ICertBasedAuthTelemetryHelper mTelemetryHelper;
    private boolean mIsOnDeviceCertBasedAuthProceeding;

    public OnDeviceCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        this.mActivity = activity;
        this.mTelemetryHelper = telemetryHelper;
        this.mTelemetryHelper.setCertBasedAuthChallengeHandler(TAG);
        this.mIsOnDeviceCertBasedAuthProceeding = false;
    }

    @Override
    @RequiresApi(api=21)
    public Void processChallenge(final ClientCertRequest request) {
        final String methodTag = TAG + ":processChallenge";
        Principal[] acceptableCertIssuers = request.getPrincipals();
        if (acceptableCertIssuers != null) {
            for (Principal issuer : acceptableCertIssuers) {
                if (!issuer.getName().contains(ACCEPTABLE_ISSUER)) continue;
                String message = "Cancelling the TLS request, not respond to TLS challenge triggered by device authentication.";
                Logger.info(methodTag, "Cancelling the TLS request, not respond to TLS challenge triggered by device authentication.");
                this.mTelemetryHelper.setResultFailure("Cancelling the TLS request, not respond to TLS challenge triggered by device authentication.");
                request.cancel();
                return null;
            }
        }
        KeyChain.choosePrivateKeyAlias((Activity)this.mActivity, (KeyChainAliasCallback)new KeyChainAliasCallback(){

            public void alias(String alias) {
                if (alias == null) {
                    String message = "No certificate chosen by user, cancelling the TLS request.";
                    Logger.info(methodTag, "No certificate chosen by user, cancelling the TLS request.");
                    OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure("No certificate chosen by user, cancelling the TLS request.");
                    request.cancel();
                    return;
                }
                try {
                    X509Certificate[] certChain = KeyChain.getCertificateChain((Context)OnDeviceCertBasedAuthChallengeHandler.this.mActivity.getApplicationContext(), (String)alias);
                    PrivateKey privateKey = KeyChain.getPrivateKey((Context)OnDeviceCertBasedAuthChallengeHandler.this.mActivity, (String)alias);
                    Logger.info(methodTag, "Certificate is chosen by user, proceed with TLS request.");
                    OnDeviceCertBasedAuthChallengeHandler.this.mIsOnDeviceCertBasedAuthProceeding = true;
                    request.proceed(privateKey, certChain);
                    return;
                }
                catch (KeyChainException e) {
                    Logger.errorPII(methodTag, "KeyChain exception", e);
                    OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure((Exception)((Object)e));
                }
                catch (InterruptedException e) {
                    Logger.errorPII(methodTag, "InterruptedException exception", e);
                    OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure((Exception)e);
                }
                OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure("ClientCertRequest unexpectedly cancelled.");
                request.cancel();
            }
        }, (String[])request.getKeyTypes(), (Principal[])request.getPrincipals(), (String)request.getHost(), (int)request.getPort(), null);
        return null;
    }

    @Override
    public void emitTelemetryForCertBasedAuthResults(@NonNull RawAuthorizationResult response) {
        if (this.mIsOnDeviceCertBasedAuthProceeding) {
            RawAuthorizationResult.ResultCode resultCode = response.getResultCode();
            if (resultCode == RawAuthorizationResult.ResultCode.NON_OAUTH_ERROR || resultCode == RawAuthorizationResult.ResultCode.SDK_CANCELLED || resultCode == RawAuthorizationResult.ResultCode.CANCELLED) {
                BaseException exception = response.getException();
                if (exception != null) {
                    this.mTelemetryHelper.setResultFailure((Exception)exception);
                } else {
                    this.mTelemetryHelper.setResultFailure(resultCode.toString());
                }
            } else {
                this.mTelemetryHelper.setResultSuccess();
            }
        }
    }

    @Override
    public void cleanUp() {
    }
}

