/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PKeyAuthChallengeFactory {
    private static final String TAG = PKeyAuthChallengeFactory.class.getSimpleName();
    private static final String CHALLENGE_REQUEST_CERT_AUTH_DELIMITER = ";";

    public PKeyAuthChallenge getPKeyAuthChallenge(@NonNull String redirectUri) throws ClientException {
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(redirectUri);
        this.validatePKeyAuthChallenge(parameters);
        PKeyAuthChallenge.Builder builder = new PKeyAuthChallenge.Builder();
        builder.setNonce(parameters.get(PKeyAuthChallengeHandler.RequestField.Nonce.name().toLowerCase(Locale.US))).setContext(parameters.get(PKeyAuthChallengeHandler.RequestField.Context.name())).setCertAuthorities(StringExtensions.getStringTokens(parameters.get(PKeyAuthChallengeHandler.RequestField.CertAuthorities.name()), CHALLENGE_REQUEST_CERT_AUTH_DELIMITER)).setVersion(parameters.get(PKeyAuthChallengeHandler.RequestField.Version.name())).setSubmitUrl(parameters.get(PKeyAuthChallengeHandler.RequestField.SubmitUrl.name()));
        return builder.build();
    }

    public PKeyAuthChallenge getPKeyAuthChallenge(@NonNull String header, @NonNull String authority) throws ClientException, UnsupportedEncodingException {
        this.validateHeaderForPkeyAuthChallenge(header);
        Map<String, String> headerItems = this.getPKeyAuthHeader(header);
        this.validatePKeyAuthChallenge(headerItems);
        PKeyAuthChallenge.Builder builder = new PKeyAuthChallenge.Builder();
        builder.setSubmitUrl(authority).setNonce(headerItems.get(PKeyAuthChallengeHandler.RequestField.Nonce.name().toLowerCase(Locale.US))).setVersion(headerItems.get(PKeyAuthChallengeHandler.RequestField.Version.name())).setContext(headerItems.get(PKeyAuthChallengeHandler.RequestField.Context.name()));
        if (!this.isWorkplaceJoined()) {
            Logger.verbose(TAG, "Device is not workplace joined. ");
        } else if (!StringExtensions.isNullOrBlank(headerItems.get(PKeyAuthChallengeHandler.RequestField.CertThumbprint.name()))) {
            Logger.verbose(TAG, "CertThumbprint exists in the device auth challenge.");
            builder.setThumbprint(headerItems.get(PKeyAuthChallengeHandler.RequestField.CertThumbprint.name()));
        } else if (headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.CertAuthorities.name())) {
            Logger.verbose(TAG, "CertAuthorities exists in the device auth challenge.");
            String authorities = headerItems.get(PKeyAuthChallengeHandler.RequestField.CertAuthorities.name());
            builder.setCertAuthorities(StringExtensions.getStringTokens(authorities, CHALLENGE_REQUEST_CERT_AUTH_DELIMITER));
        } else {
            throw new ClientException("Device certificate request is invalid", "Both certThumbprint and cert authorities are not present");
        }
        return builder.build();
    }

    private boolean isWorkplaceJoined() {
        Class<?> certClass = AuthenticationSettings.INSTANCE.getDeviceCertificateProxy();
        return certClass != null;
    }

    private void validateHeaderForPkeyAuthChallenge(@NonNull String header) throws ClientException {
        if (StringUtil.isEmpty(header)) {
            throw new ClientException("Device certificate request is invalid", "header value is empty.");
        }
        if (!StringExtensions.hasPrefixInHeader(header, "PKeyAuth")) {
            throw new ClientException("Device certificate request is invalid", "challenge response type is wrong.");
        }
    }

    private void validatePKeyAuthChallenge(Map<String, String> headerItems) throws ClientException {
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Nonce.name()) && !headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new ClientException("Device certificate request is invalid", "Nonce is empty.");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Version.name())) {
            throw new ClientException("Device certificate request is invalid", "Version name is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.SubmitUrl.name())) {
            throw new ClientException("Device certificate request is invalid", "SubmitUrl is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Context.name())) {
            throw new ClientException("Device certificate request is invalid", "Context is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.CertAuthorities.name())) {
            throw new ClientException("Device certificate request is invalid", "CertAuthorities is empty");
        }
    }

    private Map<String, String> getPKeyAuthHeader(String headerStr) throws ClientException, UnsupportedEncodingException {
        String authenticateHeader = headerStr.substring("PKeyAuth".length());
        ArrayList<String> queryPairs = StringExtensions.splitWithQuotes(authenticateHeader, ',');
        HashMap<String, String> headerItems = new HashMap<String, String>();
        for (String queryPair : queryPairs) {
            ArrayList<String> pair = StringExtensions.splitWithQuotes(queryPair, '=');
            if (pair.size() == 2 && !StringExtensions.isNullOrBlank(pair.get(0)) && !StringExtensions.isNullOrBlank(pair.get(1))) {
                String key = pair.get(0);
                String value = pair.get(1);
                key = StringExtensions.urlFormDecode(key);
                value = StringExtensions.urlFormDecode(value);
                key = key.trim();
                value = StringExtensions.removeQuoteInHeaderValue(value.trim());
                headerItems.put(key, value);
                continue;
            }
            if (pair.size() == 1 && !StringExtensions.isNullOrBlank(pair.get(0))) {
                headerItems.put(StringExtensions.urlFormDecode(pair.get(0)).trim(), StringExtensions.urlFormDecode(""));
                continue;
            }
            throw new ClientException("Device certificate request is invalid", authenticateHeader);
        }
        return headerItems;
    }
}

