/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.NtlmChallenge;
import org.xmlpull.v1.XmlPullParser;

public final class NtlmChallengeHandler
implements IChallengeHandler<NtlmChallenge, Void> {
    private static final String TAG = NtlmChallengeHandler.class.getSimpleName();
    private Activity mActivity;
    private IAuthorizationCompletionCallback mChallengeCallback;

    public NtlmChallengeHandler(Activity activity, IAuthorizationCompletionCallback callback) {
        this.mActivity = activity;
        this.mChallengeCallback = callback;
    }

    @Override
    public Void processChallenge(NtlmChallenge ntlmChallenge) {
        this.showHttpAuthDialog(ntlmChallenge);
        return null;
    }

    private void showHttpAuthDialog(final NtlmChallenge ntlmChallenge) {
        LayoutInflater factory = LayoutInflater.from((Context)this.mActivity);
        View v = factory.inflate((XmlPullParser)this.mActivity.getResources().getLayout(R.layout.http_auth_dialog), null);
        final EditText usernameView = (EditText)v.findViewById(R.id.editUserName);
        final EditText passwordView = (EditText)v.findViewById(R.id.editPassword);
        String title = this.mActivity.getText(R.string.http_auth_dialog_title).toString();
        AlertDialog.Builder httpAuthDialog = new AlertDialog.Builder((Context)this.mActivity);
        httpAuthDialog.setTitle((CharSequence)title).setView(v).setPositiveButton(R.string.http_auth_dialog_login, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                Logger.verbose(TAG, "Proceeding with user supplied username and password.");
                ntlmChallenge.getHandler().proceed(usernameView.getText().toString(), passwordView.getText().toString());
            }
        }).setNegativeButton(R.string.http_auth_dialog_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                ntlmChallenge.getHandler().cancel();
                NtlmChallengeHandler.this.cancelRequest();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                ntlmChallenge.getHandler().cancel();
                NtlmChallengeHandler.this.cancelRequest();
            }
        }).create().show();
    }

    private void cancelRequest() {
        Logger.verbose(TAG, "Sending intent to cancel authentication activity");
        this.mChallengeCallback.onChallengeResponseReceived(2001, new Intent());
    }
}

