/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.events;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;

public class BrokerEndEvent
extends BaseEvent {
    public BrokerEndEvent() {
        this.names("broker_end_event");
        this.types("broker_event");
    }

    public BrokerEndEvent putAction(String actionName) {
        this.put("broker_action", actionName);
        return this;
    }

    public BrokerEndEvent isSuccessful(boolean isSuccessful) {
        this.put("is_successful", String.valueOf(isSuccessful));
        return this;
    }

    public BrokerEndEvent putException(@NonNull BaseException exception) {
        if (exception instanceof UserCancelException) {
            this.put("user_cancelled", "true");
        }
        this.put("server_error_code", exception.getCliTelemErrorCode());
        this.put("server_sub_error_code", exception.getCliTelemSubErrorCode());
        this.put("error_code", exception.getErrorCode());
        this.put("spe_ring", exception.getSpeRing());
        this.put("error_description", exception.getMessage());
        this.put("rt_age", exception.getRefreshTokenAge());
        this.put("is_successful", "false");
        return this;
    }

    public BrokerEndEvent putErrorCode(@NonNull String errorCode) {
        this.put("error_code", errorCode);
        return this;
    }

    public BrokerEndEvent putErrorDescription(@NonNull String errorDescription) {
        this.put("error_description", errorDescription);
        return this;
    }
}

