/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.events;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;

public class ApiStartEvent
extends BaseEvent {
    private static final String TAG = ApiStartEvent.class.getSimpleName();

    public ApiStartEvent() {
        this.names("api_start_event");
        this.types("api_event");
    }

    @Override
    public ApiStartEvent put(@NonNull String propertyName, String propertyValue) {
        super.put(propertyName, propertyValue);
        return this;
    }

    public ApiStartEvent putProperties(@NonNull OperationParameters parameters) {
        if (parameters.getAuthority() != null) {
            this.put("authority", parameters.getAuthority().toString());
            this.put("authority_type", parameters.getAuthority().getAuthorityTypeString());
        }
        this.put("sdk_name", parameters.getSdkType().name());
        this.put("sdk_version", parameters.getSdkVersion());
        this.put("claim_request", StringUtil.isEmpty(parameters.getClaimsRequestJson()) ? "false" : "true");
        this.put("redirect_uri", parameters.getRedirectUri());
        this.put("client_id", parameters.getClientId());
        if (parameters instanceof AcquireTokenOperationParameters) {
            this.put("user_agent", ((AcquireTokenOperationParameters)parameters).getAuthorizationAgent().name());
            this.put("login_hint", ((AcquireTokenOperationParameters)parameters).getLoginHint());
            if (null != ((AcquireTokenOperationParameters)parameters).getExtraQueryStringParameters()) {
                this.put("query_params", String.valueOf(((AcquireTokenOperationParameters)parameters).getExtraQueryStringParameters().size()));
            }
        }
        if (parameters instanceof AcquireTokenSilentOperationParameters) {
            this.put("user_id", parameters.getAccount().getHomeAccountId());
            this.put("force_refresh", String.valueOf(((AcquireTokenSilentOperationParameters)parameters).getForceRefresh()));
            this.put("broker_protocol_version", String.valueOf(((AcquireTokenSilentOperationParameters)parameters).getRequiredBrokerProtocolVersion()));
            if (parameters.getScopes() != null) {
                this.put("scope_size", String.valueOf(parameters.getScopes().size()));
                this.put("scope_value", parameters.getScopes().toString());
            }
        }
        if (parameters instanceof BrokerAcquireTokenOperationParameters) {
            // empty if block
        }
        if (parameters instanceof BrokerAcquireTokenSilentOperationParameters) {
            // empty if block
        }
        return this;
    }

    public ApiStartEvent authority(@NonNull String authority) {
        this.put("authority", ApiStartEvent.sanitizeUrlForTelemetry(authority));
        return this;
    }

    public ApiStartEvent putAuthorityType(@NonNull String authorityType) {
        this.put("authority_type", authorityType);
        return this;
    }

    public ApiStartEvent putUiBehavior(@NonNull String uiBehavior) {
        this.put("ui_behavior", uiBehavior);
        return this;
    }

    public ApiStartEvent putApiId(@NonNull String apiId) {
        this.put("api_id", apiId);
        return this;
    }

    public ApiStartEvent putValidationStatus(@NonNull String validationStatus) {
        this.put("authority_validation_status", validationStatus);
        return this;
    }

    public ApiStartEvent putLoginHint(@NonNull String loginHint) {
        try {
            this.put("login_hint", StringExtensions.createHash(loginHint));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            Logger.warn(TAG, exception.getMessage());
        }
        return this;
    }

    public ApiStartEvent putExtendedExpiresOnSetting(@NonNull String extendedExpiresOnSetting) {
        this.put("extended_expires_on_setting", extendedExpiresOnSetting);
        return this;
    }

    private static String sanitizeUrlForTelemetry(@NonNull String url) {
        URL urlToSanitize = null;
        try {
            urlToSanitize = new URL(url);
        }
        catch (MalformedURLException e1) {
            Logger.errorPII(TAG, "Url is invalid", e1);
        }
        return urlToSanitize == null ? null : ApiStartEvent.sanitizeUrlForTelemetry(urlToSanitize);
    }

    private static String sanitizeUrlForTelemetry(@NonNull URL url) {
        String authority = url.getAuthority();
        String[] splitArray = url.getPath().split("/");
        StringBuilder logPath = new StringBuilder();
        logPath.append(url.getProtocol()).append("://").append(authority).append('/');
        for (int i = 2; i < splitArray.length; ++i) {
            logPath.append(splitArray[i]);
            logPath.append('/');
        }
        return logPath.toString();
    }
}

