/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.Environment;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.AdalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.IBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.util.QueryParamsAdapter;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class MsalBrokerRequestAdapter
implements IBrokerRequestAdapter {
    private static final String TAG = MsalBrokerRequestAdapter.class.getName();

    @Override
    public BrokerRequest brokerRequestFromAcquireTokenParameters(@NonNull AcquireTokenOperationParameters parameters) {
        Logger.verbose(TAG, "Constructing result bundle from AcquireTokenOperationParameters.");
        BrokerRequest brokerRequest = new BrokerRequest.Builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", parameters.getScopes())).redirect(this.getRedirectUri(parameters)).clientId(parameters.getClientId()).username(parameters.getLoginHint()).extraQueryStringParameter(parameters.getExtraQueryStringParameters() != null ? QueryParamsAdapter._toJson(parameters.getExtraQueryStringParameters()) : null).prompt(parameters.getOpenIdConnectPromptParameter().name()).claims(parameters.getClaimsRequestJson()).forceRefresh(!TextUtils.isEmpty((CharSequence)parameters.getClaimsRequestJson())).correlationId((String)DiagnosticContext.getRequestContext().get("correlation_id")).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).environment(AzureActiveDirectory.getEnvironment().name()).build();
        return brokerRequest;
    }

    @Override
    public BrokerRequest brokerRequestFromSilentOperationParameters(@NonNull AcquireTokenSilentOperationParameters parameters) {
        Logger.verbose(TAG, "Constructing result bundle from AcquireTokenSilentOperationParameters.");
        BrokerRequest brokerRequest = new BrokerRequest.Builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", parameters.getScopes())).redirect(this.getRedirectUri(parameters)).clientId(parameters.getClientId()).homeAccountId(parameters.getAccount().getHomeAccountId()).localAccountId(parameters.getAccount().getLocalAccountId()).username(parameters.getAccount().getUsername()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.getForceRefresh() || !TextUtils.isEmpty((CharSequence)parameters.getClaimsRequestJson())).correlationId((String)DiagnosticContext.getRequestContext().get("correlation_id")).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).environment(AzureActiveDirectory.getEnvironment().name()).build();
        return brokerRequest;
    }

    @Override
    public BrokerAcquireTokenOperationParameters brokerInteractiveParametersFromActivity(@NonNull Activity callingActivity) {
        Logger.verbose(TAG, "Constructing BrokerAcquireTokenOperationParameters from calling activity");
        BrokerAcquireTokenOperationParameters parameters = new BrokerAcquireTokenOperationParameters();
        Intent intent = callingActivity.getIntent();
        BrokerRequest brokerRequest = (BrokerRequest)new Gson().fromJson(intent.getStringExtra("broker_request_v2"), BrokerRequest.class);
        parameters.setActivity(callingActivity);
        parameters.setAppContext(callingActivity.getApplicationContext());
        parameters.setSdkType(SdkType.MSAL);
        int callingAppUid = intent.getIntExtra("caller.info.uid", 0);
        parameters.setCallerUId(callingAppUid);
        parameters.setCallerPackageName(brokerRequest.getApplicationName());
        parameters.setCallerAppVersion(brokerRequest.getApplicationVersion());
        ArrayList<Pair<String, String>> extraQP = new ArrayList();
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getExtraQueryStringParameter())) {
            extraQP = QueryParamsAdapter._fromJson(brokerRequest.getExtraQueryStringParameter());
            parameters.setExtraQueryStringParameters(extraQP);
        }
        parameters.setAuthority(AdalBrokerRequestAdapter.getRequestAuthorityWithExtraQP(brokerRequest.getAuthority(), extraQP));
        parameters.setScopes(this.getScopesAsSet(brokerRequest.getScope()));
        parameters.setClientId(brokerRequest.getClientId());
        parameters.setRedirectUri(brokerRequest.getRedirect());
        parameters.setLoginHint(brokerRequest.getUserName());
        String correlationIdString = brokerRequest.getCorrelationId();
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        parameters.setCorrelationId(correlationIdString);
        parameters.setClaimsRequest(brokerRequest.getClaims());
        parameters.setOpenIdConnectPromptParameter(OpenIdConnectPromptParameter.valueOf(brokerRequest.getPrompt()));
        parameters.setAuthorizationAgent(AuthorizationAgent.WEBVIEW);
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getEnvironment())) {
            AzureActiveDirectory.setEnvironment(Environment.valueOf(brokerRequest.getEnvironment()));
        }
        return parameters;
    }

    @Override
    public BrokerAcquireTokenSilentOperationParameters brokerSilentParametersFromBundle(@NonNull Bundle bundle, @NonNull Context context, @NonNull Account account) {
        Logger.verbose(TAG, "Constructing BrokerAcquireTokenSilentOperationParameters from result bundle");
        BrokerRequest brokerRequest = (BrokerRequest)new Gson().fromJson(bundle.getString("broker_request_v2"), BrokerRequest.class);
        BrokerAcquireTokenSilentOperationParameters parameters = new BrokerAcquireTokenSilentOperationParameters();
        parameters.setAppContext(context);
        parameters.setAccountManagerAccount(account);
        parameters.setSdkType(SdkType.MSAL);
        int callingAppUid = bundle.getInt("caller.info.uid");
        parameters.setCallerUId(callingAppUid);
        parameters.setCallerPackageName(brokerRequest.getApplicationName());
        parameters.setCallerAppVersion(brokerRequest.getApplicationVersion());
        Authority authority = Authority.getAuthorityFromAuthorityUrl(brokerRequest.getAuthority());
        parameters.setAuthority(authority);
        String correlationIdString = bundle.getString(brokerRequest.getCorrelationId());
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        parameters.setCorrelationId(correlationIdString);
        parameters.setScopes(this.getScopesAsSet(brokerRequest.getScope()));
        parameters.setRedirectUri(brokerRequest.getRedirect());
        parameters.setClientId(brokerRequest.getClientId());
        parameters.setForceRefresh(brokerRequest.getForceRefresh());
        parameters.setClaimsRequest(brokerRequest.getClaims());
        parameters.setLoginHint(brokerRequest.getUserName());
        parameters.setHomeAccountId(brokerRequest.getHomeAccountId());
        parameters.setLocalAccountId(brokerRequest.getLocalAccountId());
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getExtraQueryStringParameter())) {
            parameters.setExtraQueryStringParameters(QueryParamsAdapter._fromJson(brokerRequest.getExtraQueryStringParameter()));
        }
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getEnvironment())) {
            AzureActiveDirectory.setEnvironment(Environment.valueOf(brokerRequest.getEnvironment()));
        }
        return parameters;
    }

    private Set<String> getScopesAsSet(@Nullable String scopeString) {
        if (TextUtils.isEmpty((CharSequence)scopeString)) {
            return new HashSet<String>();
        }
        String[] scopes = scopeString.split(" ");
        return new HashSet<String>(Arrays.asList(scopes));
    }

    public static Bundle getBrokerHelloBundle(@NonNull OperationParameters parameters) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("broker.protocol.version.name", "3.0");
        if (!StringUtil.isEmpty(parameters.getRequiredBrokerProtocolVersion())) {
            requestBundle.putString("required.broker.protocol.version.name", parameters.getRequiredBrokerProtocolVersion());
        }
        return requestBundle;
    }

    private String getRedirectUri(@NonNull OperationParameters parameters) {
        if (TextUtils.isEmpty((CharSequence)parameters.getRedirectUri())) {
            return BrokerValidator.getBrokerRedirectUri(parameters.getAppContext(), parameters.getApplicationName());
        }
        return parameters.getRedirectUri();
    }
}

