/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.content.Intent;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationErrorResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.HashMap;

public class MicrosoftStsAuthorizationResultFactory
extends AuthorizationResultFactory<MicrosoftStsAuthorizationResult, MicrosoftStsAuthorizationRequest> {
    private static final String TAG = MicrosoftStsAuthorizationResultFactory.class.getSimpleName();
    protected static final String ERROR_SUBCODE = "error_subcode";
    public static final String MSSTS_AUTHORIZATION_FINAL_URL = "com.microsoft.identity.client.final.url";

    @Override
    public MicrosoftStsAuthorizationResult createAuthorizationResult(int resultCode, Intent data, MicrosoftStsAuthorizationRequest request) {
        MicrosoftStsAuthorizationResult result;
        if (data == null) {
            return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "Received null intent");
        }
        switch (resultCode) {
            case 2001: {
                Logger.verbose(TAG, null, "User cancel the authorization request in UI.");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.USER_CANCEL, "user_cancelled", "User pressed device back button to cancel the flow.");
                break;
            }
            case 2008: {
                Logger.verbose(TAG, null, "SDK cancelled the authorization request.");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.SDK_CANCEL, "auth_cancelled_by_sdk", "Sdk cancelled the auth flow as the app launched a new interactive auth request.");
                break;
            }
            case 2003: {
                String url = data.getStringExtra(MSSTS_AUTHORIZATION_FINAL_URL);
                result = this.parseUrlAndCreateAuthorizationResponse(url, request.getState());
                break;
            }
            case 2002: {
                String error = data.getStringExtra("com.microsoft.aad.adal:BrowserErrorCode");
                String errorSubcode = data.getStringExtra("com.microsoft.aad.adal:BrowserErrorSubCode");
                String errorDescription = data.getStringExtra("com.microsoft.aad.adal:BrowserErrorMessage");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, error, errorSubcode, errorDescription);
                break;
            }
            case 2006: {
                Logger.verbose(TAG, "Device needs to have broker installed, we expect the apps to call usback when the broker is installed");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "Device needs to have broker installed");
                break;
            }
            case 2007: {
                Logger.verbose(TAG, "Device Registration needed, need to start WPJ");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "Device needs to be registered to access the resource", "Device needs to be registered to access the resource");
                ((MicrosoftStsAuthorizationErrorResponse)result.getAuthorizationErrorResponse()).setUserName(data.getStringExtra("username"));
                break;
            }
            default: {
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "Unknown error", "Unknown result code returned ");
            }
        }
        return result;
    }

    private MicrosoftStsAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, String error, String errorSubcode, String errorDescription) {
        Logger.info(TAG, "Error is returned from webview redirect");
        Logger.infoPII(TAG, "error: " + error + "error subcode:" + errorSubcode + " errorDescription: " + errorDescription);
        MicrosoftStsAuthorizationErrorResponse errorResponse = new MicrosoftStsAuthorizationErrorResponse(error, errorSubcode, errorDescription);
        return new MicrosoftStsAuthorizationResult(authStatus, errorResponse);
    }

    private MicrosoftStsAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, String error, String errorDescription) {
        Logger.info(TAG, "Error is returned from webview redirect");
        Logger.infoPII(TAG, "error: " + error + " errorDescription: " + errorDescription);
        MicrosoftStsAuthorizationErrorResponse errorResponse = new MicrosoftStsAuthorizationErrorResponse(error, errorDescription);
        return new MicrosoftStsAuthorizationResult(authStatus, errorResponse);
    }

    private MicrosoftStsAuthorizationResult parseUrlAndCreateAuthorizationResponse(String url, String requestStateParameter) {
        MicrosoftStsAuthorizationResult result;
        HashMap<String, String> urlParameters;
        HashMap<String, String> hashMap = urlParameters = StringUtil.isEmpty(url) ? null : StringExtensions.getUrlParameters(url);
        if (urlParameters == null || urlParameters.isEmpty()) {
            Logger.warn(TAG, "Invalid server response, empty query string from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response.");
        } else {
            result = urlParameters.containsKey("code") ? this.validateAndCreateAuthorizationResult(urlParameters, requestStateParameter) : (urlParameters.containsKey("error") ? this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, urlParameters.get("error"), urlParameters.get(ERROR_SUBCODE), urlParameters.get("error_description")) : this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response."));
        }
        return result;
    }

    private MicrosoftStsAuthorizationResult validateAndCreateAuthorizationResult(HashMap<String, String> urlParameters, String requestStateParameter) {
        MicrosoftStsAuthorizationResult result;
        String state = urlParameters.get("state");
        String code = urlParameters.get("code");
        if (StringUtil.isEmpty(state)) {
            Logger.warn(TAG, "State parameter is not returned from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "State is not returned");
        } else if (StringUtil.isEmpty(requestStateParameter) || !requestStateParameter.equals(state)) {
            Logger.warn(TAG, "State parameter returned from the redirect is not same as the one sent in request.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "Returned state from authorize endpoint is not the same as the one sent");
        } else {
            Logger.info(TAG, "Auth code is successfully returned from webview redirect.");
            MicrosoftStsAuthorizationResponse authResponse = new MicrosoftStsAuthorizationResponse(code, state, urlParameters);
            result = new MicrosoftStsAuthorizationResult(AuthorizationStatus.SUCCESS, authResponse);
        }
        return result;
    }
}

