/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.tokensharing;

import android.net.Uri;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.adal.internal.tokensharing.ITokenShareInternal;
import com.microsoft.identity.common.adal.internal.tokensharing.SSOStateSerializer;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.cache.ADALTokenCacheItem;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.migration.AdalMigrationAdapter;
import com.microsoft.identity.common.internal.migration.TokenCacheItemMigrationAdapter;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class TokenShareUtility
implements ITokenShareInternal {
    private static final String TAG = TokenShareUtility.class.getSimpleName();
    private static final Map<String, String> sClaimRemapper = new HashMap<String, String>();
    private static final String AUDIENCE_PATH_CONSUMERS = "/consumers";
    private static final String sHomeTenantAuthority = "https://login.windows.net/common";
    private final String mClientId;
    private final String mRedirectUri;
    private final String mDefaultAuthority;
    private final MsalOAuth2TokenCache mTokenCache;

    private static void applyV1ToV2Mappings() {
        sClaimRemapper.put("preferred_username", "upn");
    }

    public TokenShareUtility(@NonNull String clientId, @NonNull String redirectUri, @NonNull String defaultAuthority, @NonNull MsalOAuth2TokenCache cache) {
        this.mClientId = clientId;
        this.mRedirectUri = redirectUri;
        this.mDefaultAuthority = defaultAuthority;
        this.mTokenCache = cache;
    }

    @Override
    @NonNull
    public String getOrgIdFamilyRefreshToken(@NonNull String identifier) throws BaseException {
        ICacheRecord cacheRecord = this.getCacheRecordForIdentifier(identifier);
        this.throwIfCacheRecordIncomplete(identifier, cacheRecord);
        ADALTokenCacheItem cacheItemToExport = TokenShareUtility.adapt(cacheRecord.getIdToken(), cacheRecord.getRefreshToken());
        return SSOStateSerializer.serialize(cacheItemToExport);
    }

    private void throwIfCacheRecordIncomplete(@NonNull String identifier, @NonNull ICacheRecord cacheRecord) throws ClientException {
        if (null == cacheRecord.getRefreshToken() || null == cacheRecord.getIdToken()) {
            String methodName = ":throwIfCacheRecordIncomplete";
            Logger.warn(TAG + ":throwIfCacheRecordIncomplete", "That's strange, we had an AccountRecord for identifier: " + identifier + " but couldn't find tokens for them.");
            throw new ClientException("token_cache_item_not_found");
        }
    }

    private ICacheRecord getCacheRecordForIdentifier(@NonNull String identifier) throws ClientException {
        AccountRecord localAccountRecord = this.getAccountRecordForIdentifier(identifier);
        return this.mTokenCache.load(this.mClientId, null, localAccountRecord);
    }

    private AccountRecord getAccountRecordForIdentifier(@NonNull String identifier) throws ClientException {
        List<AccountRecord> accountRecords;
        AccountRecord localAccountRecord = this.mTokenCache.getAccountByLocalAccountId(null, this.mClientId, identifier);
        if (null == localAccountRecord && !(accountRecords = this.mTokenCache.getAccountsByUsername(null, this.mClientId, identifier)).isEmpty()) {
            localAccountRecord = accountRecords.get(0);
        }
        if (null == localAccountRecord) {
            throw new ClientException("token_cache_item_not_found");
        }
        return localAccountRecord;
    }

    @Override
    public void saveOrgIdFamilyRefreshToken(final @NonNull String ssoStateSerializerBlob) throws Exception {
        Future<Pair<MicrosoftAccount, MicrosoftRefreshToken>> resultFuture = TokenCacheItemMigrationAdapter.sBackgroundExecutor.submit(new Callable<Pair<MicrosoftAccount, MicrosoftRefreshToken>>(){

            @Override
            public Pair<MicrosoftAccount, MicrosoftRefreshToken> call() throws ClientException {
                ADALTokenCacheItem cacheItemToRenew = SSOStateSerializer.deserialize(ssoStateSerializerBlob);
                cacheItemToRenew.setClientId(TokenShareUtility.this.mClientId);
                cacheItemToRenew.setResource(null);
                return TokenCacheItemMigrationAdapter.renewToken(TokenShareUtility.this.mRedirectUri, cacheItemToRenew);
            }
        });
        Pair<MicrosoftAccount, MicrosoftRefreshToken> resultPair = resultFuture.get();
        this.saveResult(resultPair);
    }

    private void saveResult(@Nullable Pair<MicrosoftAccount, MicrosoftRefreshToken> resultPair) throws ClientException {
        if (null != resultPair) {
            this.mTokenCache.setSingleSignOnState((BaseAccount)resultPair.first, (RefreshToken)resultPair.second);
        }
    }

    @Override
    public String getMsaFamilyRefreshToken(@NonNull String identifier) throws Exception {
        ICacheRecord cacheRecord = this.getCacheRecordForIdentifier(identifier);
        this.throwIfCacheRecordIncomplete(identifier, cacheRecord);
        return cacheRecord.getRefreshToken().getSecret();
    }

    @Override
    public void saveMsaFamilyRefreshToken(final @NonNull String refreshToken) throws Exception {
        String methodName = "saveMsaFamilyRefreshToken";
        Future<Pair<MicrosoftAccount, MicrosoftRefreshToken>> resultFuture = TokenCacheItemMigrationAdapter.sBackgroundExecutor.submit(new Callable<Pair<MicrosoftAccount, MicrosoftRefreshToken>>(){

            @Override
            public Pair<MicrosoftAccount, MicrosoftRefreshToken> call() throws ClientException {
                Uri defaultAuthorityUri = Uri.parse((String)TokenShareUtility.this.mDefaultAuthority);
                String tenantPath = defaultAuthorityUri.getPath();
                String requestAuthority = null != tenantPath ? TokenShareUtility.this.mDefaultAuthority.replace(tenantPath, TokenShareUtility.AUDIENCE_PATH_CONSUMERS) : TokenShareUtility.this.mDefaultAuthority;
                ADALTokenCacheItem cacheItemToRenew = TokenShareUtility.this.createTokenCacheItem(refreshToken, requestAuthority);
                boolean cloudMetadataLoaded = AdalMigrationAdapter.loadCloudDiscoveryMetadata();
                if (!cloudMetadataLoaded) {
                    Logger.warn(TAG + "saveMsaFamilyRefreshToken", "Failed to load cloud metadata, aborting.");
                    return null;
                }
                return TokenCacheItemMigrationAdapter.renewToken(TokenShareUtility.this.mRedirectUri, cacheItemToRenew);
            }
        });
        Pair<MicrosoftAccount, MicrosoftRefreshToken> resultPair = resultFuture.get();
        this.saveResult(resultPair);
    }

    private ADALTokenCacheItem createTokenCacheItem(@NonNull String refreshToken, @NonNull String authority) {
        ADALTokenCacheItem cacheItem = new ADALTokenCacheItem();
        cacheItem.setAuthority(authority);
        cacheItem.setClientId(this.mClientId);
        cacheItem.setRefreshToken(refreshToken);
        return cacheItem;
    }

    @NonNull
    private static ADALTokenCacheItem adapt(@NonNull IdTokenRecord idTokenRecord, @NonNull RefreshTokenRecord refreshTokenRecord) throws ServiceException {
        ADALTokenCacheItem tokenCacheItem = new ADALTokenCacheItem();
        tokenCacheItem.setClientId(refreshTokenRecord.getClientId());
        tokenCacheItem.setRefreshToken(refreshTokenRecord.getSecret());
        tokenCacheItem.setRawIdToken(TokenShareUtility.mintV1IdTokenFromRawV2IdToken(idTokenRecord.getSecret()));
        tokenCacheItem.setFamilyClientId(refreshTokenRecord.getFamilyId());
        String authority = TokenShareUtility.isFromHomeTenant(idTokenRecord) ? sHomeTenantAuthority : idTokenRecord.getAuthority();
        tokenCacheItem.setAuthority(authority);
        return tokenCacheItem;
    }

    private static boolean isFromHomeTenant(@NonNull IdTokenRecord idTokenRecord) {
        boolean isHomeTenant;
        String methodName = ":isFromHomeTenant";
        String homeAccountId = idTokenRecord.getHomeAccountId();
        try {
            Map<String, ?> tokenClaims = IDToken.parseJWT(idTokenRecord.getSecret());
            String oid = (String)tokenClaims.get("oid");
            if (null != oid) {
                isHomeTenant = homeAccountId.contains(oid);
            } else {
                Logger.warn(TAG + ":isFromHomeTenant", "OID claims was missing from token.");
                isHomeTenant = false;
            }
        }
        catch (ServiceException e) {
            Logger.warn(TAG + ":isFromHomeTenant", "Failed to parse IdToken.");
            isHomeTenant = false;
        }
        return isHomeTenant;
    }

    @NonNull
    private static String mintV1IdTokenFromRawV2IdToken(@NonNull String rawV2IdToken) throws ServiceException {
        Map<String, ?> v2TokenClaims = IDToken.parseJWT(rawV2IdToken);
        JWTClaimsSet.Builder claimsSetBuilder = new JWTClaimsSet.Builder();
        for (Map.Entry<String, ?> claimEntry : v2TokenClaims.entrySet()) {
            String claimKey = claimEntry.getKey();
            Object claimValue = claimEntry.getValue();
            if ("ver".equals(claimKey)) {
                claimValue = "1";
            }
            claimsSetBuilder.claim(TokenShareUtility.remap(claimKey), claimValue);
        }
        JWTClaimsSet v1TokenClaims = claimsSetBuilder.build();
        PlainHeader plainHeader = new PlainHeader(JOSEObjectType.JWT, null, null, null, null);
        PlainJWT outboundJwt = new PlainJWT(plainHeader, v1TokenClaims);
        return outboundJwt.serialize();
    }

    @NonNull
    private static String remap(@NonNull String claimKey) {
        String remappedValue = sClaimRemapper.get(claimKey);
        if (null == remappedValue) {
            remappedValue = claimKey;
        }
        return remappedValue;
    }

    static {
        TokenShareUtility.applyV1ToV2Mappings();
    }
}

