/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.tokensharing;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.identity.common.internal.cache.ADALTokenCacheItem;
import java.lang.reflect.Type;

public final class TokenCacheItemSerializationAdapater
implements JsonDeserializer<ADALTokenCacheItem>,
JsonSerializer<ADALTokenCacheItem> {
    private static final String TAG = TokenCacheItemSerializationAdapater.class.getSimpleName();

    public JsonElement serialize(ADALTokenCacheItem tokenCacheItem, Type type, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.add("authority", (JsonElement)new JsonPrimitive(tokenCacheItem.getAuthority()));
        jsonObj.add("refresh_token", (JsonElement)new JsonPrimitive(tokenCacheItem.getRefreshToken()));
        jsonObj.add("id_token", (JsonElement)new JsonPrimitive(tokenCacheItem.getRawIdToken()));
        jsonObj.add("foci", (JsonElement)new JsonPrimitive(tokenCacheItem.getFamilyClientId()));
        return jsonObj;
    }

    public ADALTokenCacheItem deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject srcJsonObj = json.getAsJsonObject();
        this.throwIfParameterMissing(srcJsonObj, "authority");
        this.throwIfParameterMissing(srcJsonObj, "id_token");
        this.throwIfParameterMissing(srcJsonObj, "foci");
        this.throwIfParameterMissing(srcJsonObj, "refresh_token");
        String rawIdToken = srcJsonObj.get("id_token").getAsString();
        ADALTokenCacheItem tokenCacheItem = new ADALTokenCacheItem();
        tokenCacheItem.setAuthority(srcJsonObj.get("authority").getAsString());
        tokenCacheItem.setRawIdToken(rawIdToken);
        tokenCacheItem.setFamilyClientId(srcJsonObj.get("foci").getAsString());
        tokenCacheItem.setRefreshToken(srcJsonObj.get("refresh_token").getAsString());
        return tokenCacheItem;
    }

    private void throwIfParameterMissing(JsonObject json, String name) {
        if (!json.has(name)) {
            throw new JsonParseException(TAG + "Attribute " + name + " is missing for deserialization.");
        }
    }
}

