/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.rules;

import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class TelemetryPiiOiiRules {
    private static TelemetryPiiOiiRules sInstance;
    private Set<String> piiPropertiesSet;
    private Set<String> oiiPropertiesSet;
    private final String[] piiArray = new String[]{"user_id", "device_id", "login_hint", "error_description", "query_params", "redirect_uri", "scope_value", "claim_request"};
    private final String[] oiiArray = new String[]{"tenant_id", "client_id", "redirect_uri", "http_path", "authority", "idp", "application_name", "application_version"};

    private TelemetryPiiOiiRules() {
        this.piiPropertiesSet = new HashSet<String>(Arrays.asList(this.piiArray));
        this.oiiPropertiesSet = new HashSet<String>(Arrays.asList(this.oiiArray));
    }

    public static synchronized TelemetryPiiOiiRules getInstance() {
        if (sInstance == null) {
            sInstance = new TelemetryPiiOiiRules();
        }
        return sInstance;
    }

    public boolean isPii(String propertyName) {
        if (StringUtil.isEmpty(propertyName)) {
            return false;
        }
        return this.piiPropertiesSet.contains(propertyName);
    }

    public boolean isOii(String propertyName) {
        if (StringUtil.isEmpty(propertyName)) {
            return false;
        }
        return this.oiiPropertiesSet.contains(propertyName);
    }

    public boolean isPiiOrOii(String propertyName) {
        if (StringUtil.isEmpty(propertyName)) {
            return false;
        }
        return this.piiPropertiesSet.contains(propertyName) || this.oiiPropertiesSet.contains(propertyName);
    }
}

