/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.events;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;

public class ApiEndEvent
extends BaseEvent {
    public ApiEndEvent() {
        this.names("api_end_event");
        this.types("api_event");
    }

    public ApiEndEvent putResult(@NonNull AcquireTokenResult result) {
        this.put("is_successful", result.getSucceeded().toString());
        if (null != result.getLocalAuthenticationResult()) {
            this.put("user_id", result.getLocalAuthenticationResult().getUniqueId());
            this.put("tenant_id", result.getLocalAuthenticationResult().getTenantId());
            this.put("spe_ring", result.getLocalAuthenticationResult().getSpeRing());
            this.put("rt_age", result.getLocalAuthenticationResult().getRefreshTokenAge());
        }
        return this;
    }

    public ApiEndEvent putException(@NonNull BaseException exception) {
        if (exception instanceof UserCancelException) {
            this.put("user_cancelled", "true");
        }
        this.put("server_error_code", exception.getCliTelemErrorCode());
        this.put("server_sub_error_code", exception.getCliTelemSubErrorCode());
        this.put("error_code", exception.getErrorCode());
        this.put("spe_ring", exception.getSpeRing());
        this.put("error_description", exception.getMessage());
        this.put("rt_age", exception.getRefreshTokenAge());
        this.put("is_successful", "false");
        return this;
    }

    public ApiEndEvent putApiId(@NonNull String apiId) {
        this.put("api_id", apiId);
        return this;
    }

    @Override
    public ApiEndEvent put(@NonNull String propertyName, @NonNull String propertyValue) {
        super.put(propertyName, propertyValue);
        return this;
    }

    public ApiEndEvent isApiCallSuccessful(Boolean isSuccessful) {
        this.put("is_successful", isSuccessful.toString());
        return this;
    }

    public ApiEndEvent putApiErrorCode(@NonNull String errorCode) {
        this.put("error_code", errorCode);
        return this;
    }
}

