/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.adapter;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.telemetry.adapter.ITelemetryAdapter;
import com.microsoft.identity.common.internal.telemetry.observers.ITelemetryAggregatedObserver;
import com.microsoft.identity.common.internal.telemetry.rules.TelemetryAggregationRules;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TelemetryAggregationAdapter
implements ITelemetryAdapter<List<Map<String, String>>> {
    private ITelemetryAggregatedObserver mObserver;

    public TelemetryAggregationAdapter(@NonNull ITelemetryAggregatedObserver observer) {
        this.mObserver = observer;
    }

    public ITelemetryAggregatedObserver getObserver() {
        return this.mObserver;
    }

    @Override
    public void process(@NonNull List<Map<String, String>> rawData) {
        HashMap<String, String> aggregatedData = new HashMap<String, String>();
        long apiStartTime = -1L;
        long apiEndTime = -1L;
        for (Map<String, String> event : rawData) {
            String eventName = event.get("event_name");
            String eventType = event.get("event_type");
            if (StringUtil.isEmpty(eventName)) {
                aggregatedData.putAll(this.applyAggregationRule(event));
                continue;
            }
            if (eventName.contains("start")) {
                String eventTypeCount;
                aggregatedData.put(eventTypeCount, null == aggregatedData.get(eventTypeCount = eventType + "_count") ? "1" : String.valueOf(Integer.parseInt((String)aggregatedData.get(eventTypeCount)) + 1));
            }
            long eventOccurTime = Long.parseLong(event.get("occur_time"));
            if (eventName.equalsIgnoreCase("api_start_event") && (apiStartTime == -1L || eventOccurTime < apiStartTime)) {
                apiStartTime = eventOccurTime;
            }
            if (eventName.equalsIgnoreCase("api_end_event") && (apiEndTime == -1L || eventOccurTime > apiEndTime)) {
                apiEndTime = eventOccurTime;
            }
            aggregatedData.putAll(this.applyAggregationRule(event));
        }
        aggregatedData.put("start_time", String.valueOf(apiStartTime));
        aggregatedData.put("stop_time", String.valueOf(apiEndTime));
        this.mObserver.onReceived((Map<String, String>)aggregatedData);
    }

    private Map<String, String> applyAggregationRule(@NonNull Map<String, String> properties) {
        HashMap<String, String> nonPiiProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (StringUtil.isEmpty(entry.getValue()) || TelemetryAggregationRules.getInstance().isRedundant(entry.getKey())) continue;
            nonPiiProperties.put(entry.getKey(), entry.getValue());
        }
        return nonPiiProperties;
    }
}

