/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.telemetry.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class TelemetryContext
extends Properties {
    private static final String TAG = TelemetryContext.class.getSimpleName();

    TelemetryContext(ConcurrentHashMap<String, String> delegate) {
        super(delegate);
    }

    static synchronized TelemetryContext create(Context context) {
        TelemetryContext telemetryContext = new TelemetryContext(new ConcurrentHashMap<String, String>());
        telemetryContext.addApplicationInfo(context);
        telemetryContext.addDeviceInfo();
        telemetryContext.addOsInfo();
        telemetryContext.put("time_zone", TimeZone.getDefault().getID());
        return telemetryContext;
    }

    void addApplicationInfo(@NonNull Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            this.put("app_name", packageInfo.applicationInfo.loadLabel(packageManager).toString());
            this.put("app_version", packageInfo.versionName);
            this.put("app_build", String.valueOf(packageInfo.versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn(TAG, "Unable to find the app's package name from PackageManager.");
        }
    }

    void addDeviceInfo() {
        this.put("device_manufacturer", Build.MANUFACTURER);
        this.put("device_model", Build.MODEL);
        this.put("device_name", Build.DEVICE);
    }

    void addOsInfo() {
        this.put("os_name", "android");
        this.put("os_version", Build.VERSION.RELEASE);
        if (Build.VERSION.SDK_INT >= 23) {
            this.put("security_patch", Build.VERSION.SECURITY_PATCH);
        }
    }
}

