/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationRequest;

public class AzureActiveDirectoryAuthorizationRequest
extends MicrosoftAuthorizationRequest {
    @SerializedName(value="resource")
    private String mResource;
    @SerializedName(value="prompt")
    private String mPrompt;
    @SerializedName(value="claims")
    private String mClaimsChallenge;

    protected AzureActiveDirectoryAuthorizationRequest(Builder builder) {
        super(builder);
        this.mResource = builder.mResource;
        this.mPrompt = builder.mPrompt;
        this.mClaimsChallenge = builder.mClaimsChallenge;
    }

    public String getResource() {
        return this.mResource;
    }

    public String getPrompt() {
        return this.mPrompt;
    }

    public String getClaimsChallenge() {
        return this.mClaimsChallenge;
    }

    @Override
    public String getAuthorizationEndpoint() {
        return null;
    }

    public static class Builder
    extends MicrosoftAuthorizationRequest.Builder<Builder> {
        private String mResource;
        private String mPrompt;
        private String mClaimsChallenge;

        public Builder setResource(String resource) {
            this.mResource = resource;
            return this;
        }

        @Override
        public Builder setPrompt(String prompt) {
            this.mPrompt = prompt;
            return this;
        }

        public Builder setClaimsChallenge(String claimsChallenge) {
            this.mClaimsChallenge = claimsChallenge;
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public AzureActiveDirectoryAuthorizationRequest build() {
            this.setLibraryName("ADAL.Android");
            this.setLibraryVersion("1.15.2");
            return new AzureActiveDirectoryAuthorizationRequest(this);
        }
    }

    public static final class Prompt {
        public static final String AUTO = "none";
        public static final String ALWAYS = "login";
        public static final String REFRESH_SESSION = "refresh_session";
        public static final String FORCE_PROMPT = "login";
        public static final String SELECT_ACCOUNT = "select_account";
        public static final String CONSENT = "consent";
        public static final String ADMIN_CONSENT = "admin_consent";
    }
}

