/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import android.net.Uri;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.authorities.Environment;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.net.cache.HttpCache;
import com.microsoft.identity.common.internal.providers.IdentityProvider;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryInstanceResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Strategy;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONException;

public class AzureActiveDirectory
extends IdentityProvider<AzureActiveDirectoryOAuth2Strategy, AzureActiveDirectoryOAuth2Configuration> {
    private static final String TENANT_DISCOVERY_ENDPOINT = "tenant_discovery_endpoint";
    private static final String METADATA = "metadata";
    private static final String AAD_INSTANCE_DISCOVERY_ENDPOINT = "/common/discovery/instance";
    private static final String API_VERSION = "api-version";
    private static final String API_VERSION_VALUE = "1.1";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String AUTHORIZATION_ENDPOINT_VALUE = "https://login.microsoftonline.com/common/oauth2/v2.0/authorize";
    private static ConcurrentMap<String, AzureActiveDirectoryCloud> sAadClouds = new ConcurrentHashMap<String, AzureActiveDirectoryCloud>();
    static boolean sIsInitialized = false;
    static Environment sEnvironment = Environment.Production;

    @Override
    public AzureActiveDirectoryOAuth2Strategy createOAuth2Strategy(AzureActiveDirectoryOAuth2Configuration config) {
        return new AzureActiveDirectoryOAuth2Strategy(config);
    }

    public static boolean hasCloudHost(URL authorityUrl) {
        return sAadClouds.containsKey(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    static boolean isValidCloudHost(URL authorityUrl) {
        return AzureActiveDirectory.hasCloudHost(authorityUrl) && AzureActiveDirectory.getAzureActiveDirectoryCloud(authorityUrl).isValidated();
    }

    public static boolean isInitialized() {
        return sIsInitialized;
    }

    public static void setEnvironment(Environment environment) {
        if (environment != sEnvironment) {
            sIsInitialized = false;
            sEnvironment = environment;
        }
    }

    public static Environment getEnvironment() {
        return sEnvironment;
    }

    public static AzureActiveDirectoryCloud getAzureActiveDirectoryCloud(URL authorityUrl) {
        return (AzureActiveDirectoryCloud)sAadClouds.get(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    public static void putCloud(String host, AzureActiveDirectoryCloud cloud) {
        sAadClouds.put(host.toLowerCase(Locale.US), cloud);
    }

    public static void initializeCloudMetadata(String authorityHost, Map<String, String> discoveryResponse) throws JSONException {
        boolean tenantDiscoveryEndpointReturned = discoveryResponse.containsKey(TENANT_DISCOVERY_ENDPOINT);
        String metadata = discoveryResponse.get(METADATA);
        if (!tenantDiscoveryEndpointReturned) {
            sAadClouds.put(authorityHost, new AzureActiveDirectoryCloud(false));
            return;
        }
        if (StringExtensions.isNullOrBlank(metadata)) {
            sAadClouds.put(authorityHost, new AzureActiveDirectoryCloud(authorityHost, authorityHost));
            return;
        }
        List<AzureActiveDirectoryCloud> clouds = AzureActiveDirectory.deserializeClouds(metadata);
        for (AzureActiveDirectoryCloud cloud : clouds) {
            cloud.setIsValidated(true);
            for (String alias : cloud.getHostAliases()) {
                sAadClouds.put(alias.toLowerCase(Locale.US), cloud);
            }
        }
        sIsInitialized = true;
    }

    public static String getDefaultCloudUrl() {
        if (sEnvironment == Environment.PreProduction) {
            return "https://login.windows-ppe.net";
        }
        return "https://login.microsoftonline.com";
    }

    public static void performCloudDiscovery() throws IOException {
        Uri instanceDiscoveryRequestUri = Uri.parse((String)(AzureActiveDirectory.getDefaultCloudUrl() + AAD_INSTANCE_DISCOVERY_ENDPOINT));
        HttpResponse response = HttpRequest.sendGet(new URL((instanceDiscoveryRequestUri = instanceDiscoveryRequestUri.buildUpon().appendQueryParameter(API_VERSION, API_VERSION_VALUE).appendQueryParameter(AUTHORIZATION_ENDPOINT, AUTHORIZATION_ENDPOINT_VALUE).build()).toString()), new HashMap<String, String>());
        if (response.getStatusCode() >= 400) {
            Log.d((String)"Discovery", (String)"Error getting cloud information");
        } else {
            HttpCache.flush();
            AzureActiveDirectoryInstanceResponse instanceResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), AzureActiveDirectoryInstanceResponse.class);
            for (AzureActiveDirectoryCloud cloud : instanceResponse.getClouds()) {
                cloud.setIsValidated(true);
                for (String alias : cloud.getHostAliases()) {
                    sAadClouds.put(alias.toLowerCase(Locale.US), cloud);
                }
            }
        }
        sIsInitialized = true;
    }

    public static Set<String> getHosts() {
        if (null != sAadClouds) {
            return sAadClouds.keySet();
        }
        return null;
    }

    public static List<AzureActiveDirectoryCloud> getClouds() {
        if (null != sAadClouds) {
            return new ArrayList<AzureActiveDirectoryCloud>(sAadClouds.values());
        }
        return new ArrayList<AzureActiveDirectoryCloud>();
    }

    private static List<AzureActiveDirectoryCloud> deserializeClouds(String jsonCloudArray) throws JSONException {
        Type listType = new TypeToken<List<AzureActiveDirectoryCloud>>(){}.getType();
        return (List)new Gson().fromJson(jsonCloudArray, listType);
    }
}

