/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.controllers.BaseAccountCommand;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.OperationParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class LoadAccountCommand
extends BaseAccountCommand<List<ICacheRecord>> {
    private static final String TAG = LoadAccountCommand.class.getSimpleName();

    public LoadAccountCommand(@NonNull OperationParameters parameters, @NonNull BaseController controller, @NonNull TaskCompletedCallbackWithError callback) {
        super(parameters, controller, callback);
    }

    public LoadAccountCommand(@NonNull OperationParameters parameters, @NonNull List<BaseController> controllers, @NonNull TaskCompletedCallbackWithError callback) {
        super(parameters, controllers, callback);
    }

    @Override
    public List<ICacheRecord> execute() throws ClientException, InterruptedException, ExecutionException, RemoteException, OperationCanceledException, IOException, AuthenticatorException {
        String methodName = ":execute";
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        for (int ii = 0; ii < this.getControllers().size(); ++ii) {
            BaseController controller = this.getControllers().get(ii);
            Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
            result.addAll(controller.getAccounts(this.getParameters()));
        }
        return result;
    }
}

