/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache.registry;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.internal.cache.SharedPreferencesSimpleCacheImpl;
import com.microsoft.identity.common.internal.cache.registry.BrokerApplicationRegistryData;
import com.microsoft.identity.common.internal.cache.registry.IBrokerApplicationRegistry;
import com.microsoft.identity.common.internal.logging.Logger;
import java.lang.reflect.Type;
import java.util.List;

public class DefaultBrokerApplicationRegistry
extends SharedPreferencesSimpleCacheImpl<BrokerApplicationRegistryData>
implements IBrokerApplicationRegistry {
    private static final String TAG = DefaultBrokerApplicationRegistry.class.getSimpleName();
    private static final String DEFAULT_APP_REGISTRY_CACHE_NAME = "com.microsoft.identity.app-registry";
    private static final String KEY_APP_REGISTRY = "app-registry";

    public DefaultBrokerApplicationRegistry(@NonNull Context context) {
        super(context, DEFAULT_APP_REGISTRY_CACHE_NAME, KEY_APP_REGISTRY);
    }

    @Override
    protected Type getListTypeToken() {
        return new TypeToken<List<BrokerApplicationRegistryData>>(){}.getType();
    }

    @Override
    public BrokerApplicationRegistryData getMetadata(@NonNull String clientId, @Nullable String environment, int processUid) {
        String methodName = ":getMetadata";
        List allMetadata = this.getAll();
        BrokerApplicationRegistryData result = null;
        for (BrokerApplicationRegistryData metadata : allMetadata) {
            if (!clientId.equals(metadata.getClientId()) || processUid != metadata.getUid() || null != environment && !environment.equals(metadata.getEnvironment())) continue;
            Logger.verbose(TAG + metadata, "Metadata located.");
            result = metadata;
            break;
        }
        if (null == result) {
            Logger.warn(TAG + ":getMetadata", "Metadata could not be found for clientId, environment: [" + clientId + ", " + environment + "]");
        }
        return result;
    }
}

