/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.adal.internal.cache.CacheKey;
import com.microsoft.identity.common.adal.internal.cache.DateTimeAdapter;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.ADALTokenCacheItem;
import com.microsoft.identity.common.internal.cache.AccountDeletionRecord;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ADALOAuth2TokenCache
extends OAuth2TokenCache<AzureActiveDirectoryOAuth2Strategy, AzureActiveDirectoryAuthorizationRequest, AzureActiveDirectoryTokenResponse>
implements IShareSingleSignOnState {
    private ISharedPreferencesFileManager mISharedPreferencesFileManager;
    static final String ERR_UNSUPPORTED_OPERATION = "This method is unsupported.";
    private static final String TAG = ADALOAuth2TokenCache.class.getSimpleName();
    private static final String SHARED_PREFERENCES_FILENAME = "com.microsoft.aad.adal.cache";
    private Gson mGson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTimeAdapter()).create();
    private List<IShareSingleSignOnState<MicrosoftAccount, MicrosoftRefreshToken>> mSharedSSOCaches;

    public ADALOAuth2TokenCache(Context context) {
        super(context);
        Logger.verbose(TAG, "Init: " + TAG);
        this.validateSecretKeySetting();
        this.initializeSharedPreferencesFileManager(SHARED_PREFERENCES_FILENAME);
        this.mSharedSSOCaches = new ArrayList<IShareSingleSignOnState<MicrosoftAccount, MicrosoftRefreshToken>>();
    }

    public ADALOAuth2TokenCache(Context context, List<IShareSingleSignOnState<MicrosoftAccount, MicrosoftRefreshToken>> sharedSSOCaches) {
        super(context);
        Logger.verbose(TAG, "Init: " + TAG);
        Logger.info(TAG, "Context is an Application? [" + (context instanceof Application) + "]");
        this.validateSecretKeySetting();
        this.initializeSharedPreferencesFileManager(SHARED_PREFERENCES_FILENAME);
        this.mSharedSSOCaches = sharedSSOCaches;
    }

    protected void initializeSharedPreferencesFileManager(String fileName) {
        Logger.verbose(TAG, "Initializing SharedPreferencesFileManager");
        Logger.verbosePII(TAG, "Initializing with name: " + fileName);
        this.mISharedPreferencesFileManager = new SharedPreferencesFileManager(this.getContext(), fileName, new StorageHelper(this.getContext()));
    }

    @Override
    public ICacheRecord save(AzureActiveDirectoryOAuth2Strategy strategy, AzureActiveDirectoryAuthorizationRequest request, AzureActiveDirectoryTokenResponse response) {
        String methodName = "save";
        Logger.info(TAG + ":" + "save", "Saving Tokens...");
        String issuerCacheIdentifier = strategy.getIssuerCacheIdentifier(request);
        AzureActiveDirectoryAccount account = strategy.createAccount(response);
        String msalEnvironment = Uri.parse((String)issuerCacheIdentifier).getAuthority();
        account.setEnvironment(msalEnvironment);
        AzureActiveDirectoryRefreshToken refreshToken = strategy.getRefreshTokenFromResponse(response);
        refreshToken.setEnvironment(msalEnvironment);
        Logger.info(TAG, "Constructing new ADALTokenCacheItem");
        ADALTokenCacheItem cacheItem = new ADALTokenCacheItem(strategy, request, response);
        ADALOAuth2TokenCache.logTokenCacheItem(cacheItem);
        Logger.info(TAG + ":" + "save", "Setting items to cache for user...");
        for (String string : account.getCacheIdentifiers()) {
            String scope = request.getScope();
            String clientId = request.getClientId();
            Logger.infoPII(TAG + ":" + "save", "issuerCacheIdentifier: [" + issuerCacheIdentifier + "]");
            Logger.infoPII(TAG + ":" + "save", "scope: [" + scope + "]");
            Logger.infoPII(TAG + ":" + "save", "clientId: [" + clientId + "]");
            Logger.infoPII(TAG + ":" + "save", "cacheIdentifier: [" + string + "]");
            this.setItemToCacheForUser(issuerCacheIdentifier, scope, clientId, cacheItem, string);
        }
        this.setItemToCacheForUser(issuerCacheIdentifier, request.getScope(), request.getClientId(), cacheItem, null);
        Logger.info(TAG + ":" + "save", "Syncing SSO state to caches...");
        for (IShareSingleSignOnState iShareSingleSignOnState : this.mSharedSSOCaches) {
            try {
                iShareSingleSignOnState.setSingleSignOnState(account, refreshToken);
            }
            catch (ClientException e) {
                Logger.errorPII(TAG, "Exception setting single sign on state for account " + account.getUsername(), e);
            }
        }
        return null;
    }

    @Override
    public List<ICacheRecord> saveAndLoadAggregatedAccountData(AzureActiveDirectoryOAuth2Strategy oAuth2Strategy, AzureActiveDirectoryAuthorizationRequest request, AzureActiveDirectoryTokenResponse response) throws ClientException {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public ICacheRecord save(AccountRecord accountRecord, IdTokenRecord idTokenRecord) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public ICacheRecord load(String clientId, String target, AccountRecord account) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public List<ICacheRecord> loadWithAggregatedAccountData(String clientId, String target, AccountRecord account) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public boolean removeCredential(Credential credential) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public AccountRecord getAccount(String environment, String clientId, String homeAccountId, String realm) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(String environment, String clientId, String homeAccountId) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public AccountRecord getAccountByLocalAccountId(String environment, String clientId, String localAccountId) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(String environment, String clientId, String localAccountId) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public List<AccountRecord> getAccounts(String environment, String clientId) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public List<AccountRecord> getAllTenantAccountsForAccountByClientId(String clientId, AccountRecord accountRecord) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public List<ICacheRecord> getAccountsWithAggregatedAccountData(String environment, String clientId) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public List<IdTokenRecord> getIdTokensForAccountRecord(String clientId, AccountRecord accountRecord) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public AccountDeletionRecord removeAccount(String environment, String clientId, String homeAccountId, String realm) {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    public void clearAll() {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    @Override
    protected Set<String> getAllClientIds() {
        throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
    }

    private static void logTokenCacheItem(ADALTokenCacheItem tokenCacheItem) {
        Logger.info(TAG, "Logging TokenCacheItem");
        Logger.infoPII(TAG, "resource: [" + tokenCacheItem.getResource() + "]");
        Logger.infoPII(TAG, "authority: [" + tokenCacheItem.getAuthority() + "]");
        Logger.infoPII(TAG, "clientId: [" + tokenCacheItem.getClientId() + "]");
        Logger.infoPII(TAG, "expiresOn: [" + tokenCacheItem.getExpiresOn() + "]");
        Logger.infoPII(TAG, "isMrrt: [" + tokenCacheItem.getIsMultiResourceRefreshToken() + "]");
        Logger.infoPII(TAG, "tenantId: [" + tokenCacheItem.getTenantId() + "]");
        Logger.infoPII(TAG, "foci: [" + tokenCacheItem.getFamilyClientId() + "]");
        Logger.infoPII(TAG, "extendedExpires: [" + tokenCacheItem.getExtendedExpiresOn() + "]");
        Logger.infoPII(TAG, "speRing: [" + tokenCacheItem.getSpeRing() + "]");
    }

    private void setItemToCacheForUser(String issuer, String resource, String clientId, ADALTokenCacheItem cacheItem, String userId) {
        String methodName = "setItemToCacheForUser";
        Logger.info(TAG + ":" + "setItemToCacheForUser", "Setting cacheitem for RT entry.");
        this.setItem(CacheKey.createCacheKeyForRTEntry(issuer, resource, clientId, userId), cacheItem);
        if (cacheItem.getIsMultiResourceRefreshToken()) {
            Logger.info(TAG + ":" + "setItemToCacheForUser", "CacheItem is an MRRT.");
            this.setItem(CacheKey.createCacheKeyForMRRT(issuer, clientId, userId), ADALTokenCacheItem.getAsMRRTTokenCacheItem(cacheItem));
        }
        if (!StringExtensions.isNullOrBlank(cacheItem.getFamilyClientId())) {
            Logger.info(TAG + ":" + "setItemToCacheForUser", "CacheItem is an FRT.");
            this.setItem(CacheKey.createCacheKeyForFRT(issuer, cacheItem.getFamilyClientId(), userId), ADALTokenCacheItem.getAsFRTTokenCacheItem(cacheItem));
        }
    }

    private void setItem(String key, ADALTokenCacheItem cacheItem) {
        Logger.info(TAG, "Setting item to cache");
        String json = this.mGson.toJson((Object)cacheItem);
        this.mISharedPreferencesFileManager.putString(key, json);
    }

    private void validateSecretKeySetting() {
        Logger.verbose(TAG, "Validating secret key settings.");
        byte[] secretKeyData = AuthenticationSettings.INSTANCE.getSecretKeyData();
        if (secretKeyData == null && Build.VERSION.SDK_INT < 18) {
            throw new IllegalArgumentException("Secret key must be provided for API < 18. Use AuthenticationSettings.INSTANCE.setSecretKey()");
        }
    }

    public void setSingleSignOnState(BaseAccount account, RefreshToken refreshToken) {
        Logger.warn(TAG, "setSingleSignOnState was called, but is not implemented.");
    }

    public RefreshToken getSingleSignOnState(BaseAccount account) {
        Logger.warn(TAG, "getSingleSignOnState was called, but is not implemented.");
        RefreshToken refreshToken = null;
        return refreshToken;
    }
}

