/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.exception;

import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.net.HttpResponse;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;

public class ServiceException
extends BaseException {
    public static final String OPENID_PROVIDER_CONFIGURATION_FAILED_TO_LOAD = "failed_to_load_openid_configuration";
    public static final String INVALID_REQUEST = "invalid_request";
    public static final String UNAUTHORIZED_CLIENT = "unauthorized_client";
    public static final String ACCESS_DENIED = "access_denied";
    public static final String INVALID_SCOPE = "invalid_scope";
    public static final String SERVICE_NOT_AVAILABLE = "service_not_available";
    public static final String REQUEST_TIMEOUT = "request_timeout";
    public static final String INVALID_INSTANCE = "invalid_instance";
    public static final String UNKNOWN_ERROR = "unknown_error";
    private String mOauthSubErrorCode;
    private int mHttpStatusCode;
    private HashMap<String, String> mHttpResponseBody = null;
    private HashMap<String, List<String>> mHttpResponseHeaders = null;
    public static final int DEFAULT_STATUS_CODE = 0;

    public int getHttpStatusCode() {
        return this.mHttpStatusCode;
    }

    public String getOAuthSubErrorCode() {
        return this.mOauthSubErrorCode;
    }

    public HashMap<String, String> getHttpResponseBody() {
        return this.mHttpResponseBody;
    }

    public HashMap<String, List<String>> getHttpResponseHeaders() {
        return this.mHttpResponseHeaders;
    }

    public void setOauthSubErrorCode(@Nullable String subErrorCode) {
        this.mOauthSubErrorCode = subErrorCode;
    }

    public void setHttpResponseHeaders(HashMap<String, List<String>> responseHeaders) {
        this.mHttpResponseHeaders = responseHeaders;
    }

    public void setHttpResponseBody(HashMap<String, String> responseBody) {
        this.mHttpResponseBody = responseBody;
    }

    public void setHttpResponse(HttpResponse response) throws JSONException {
        if (null != response) {
            this.mHttpStatusCode = response.getStatusCode();
            if (null != response.getHeaders()) {
                this.mHttpResponseHeaders = new HashMap<String, List<String>>(response.getHeaders());
            }
            if (null != response.getBody()) {
                this.mHttpResponseBody = HashMapExtensions.getJsonResponse(response);
            }
        }
    }

    public ServiceException(String errorCode, String errorMessage, Throwable throwable) {
        super(errorCode, errorMessage, throwable);
        this.mHttpStatusCode = 0;
    }

    public ServiceException(String errorCode, String errorMessage, int httpStatusCode, Throwable throwable) {
        super(errorCode, errorMessage, throwable);
        this.mHttpStatusCode = httpStatusCode;
    }
}

