/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.events;

import com.microsoft.identity.common.internal.cache.CacheRecord;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.util.StringUtil;

public class CacheEndEvent
extends BaseEvent {
    public CacheEndEvent() {
        this.names("cache_end_event");
        this.types("Microsoft.MSAL.cache_event");
    }

    public CacheEndEvent putRtStatus(String rtStatus) {
        this.put("Microsoft.MSAL.rt_status", rtStatus);
        return this;
    }

    public CacheEndEvent putAtStatus(String rtStatus) {
        this.put("Microsoft.MSAL.at_status", rtStatus);
        return this;
    }

    public CacheEndEvent putFrtStatus(String frtStatus) {
        this.put("Microsoft.MSAL.frt_status", frtStatus);
        return this;
    }

    public CacheEndEvent putCacheRecordStatus(CacheRecord cacheRecord) {
        this.put("Microsoft.MSAL.at_status", cacheRecord.getAccessToken() == null ? "false" : "true");
        if (null != cacheRecord.getRefreshToken()) {
            this.put("Microsoft.MSAL.mrrt_status", "true");
            this.put("Microsoft.MSAL.rt_status", "true");
            this.put("Microsoft.MSAL.frt_status", StringUtil.isEmpty(cacheRecord.getRefreshToken().getFamilyId()) ? "false" : "true");
        } else {
            this.put("Microsoft.MSAL.rt_status", "false");
        }
        this.put("Microsoft.MSAL.id_token_status", cacheRecord.getIdToken() == null ? "false" : "true");
        this.put("Microsoft.MSAL.v1_id_token_status", cacheRecord.getV1IdToken() == null ? "false" : "true");
        this.put("Microsoft.MSAL.account_status", cacheRecord.getAccount() == null ? "false" : "true");
        return this;
    }

    public CacheEndEvent putSpeInfo(String speInfo) {
        this.put("Microsoft.MSAL.spe_info", speInfo);
        return this;
    }
}

