/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.events;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;

public class BrokerEndEvent
extends BaseEvent {
    public BrokerEndEvent() {
        this.names("broker_end_event");
        this.types("Microsoft.MSAL.broker_event");
    }

    public BrokerEndEvent putAction(String actionName) {
        this.put("Microsoft.MSAL.broker_action", actionName);
        return this;
    }

    public BrokerEndEvent isSuccessful(boolean isSuccessful) {
        this.put("_is_successful", String.valueOf(isSuccessful));
        return this;
    }

    public BrokerEndEvent putException(@NonNull BaseException exception) {
        if (exception instanceof UserCancelException) {
            this.put("Microsoft.MSAL.user_cancel", "true");
        }
        this.put("Microsoft.MSAL.server_error_code", exception.getCliTelemErrorCode());
        this.put("Microsoft.MSAL.server_sub_error_code", exception.getCliTelemSubErrorCode());
        this.put("Microsoft.MSAL.api_error_code", exception.getErrorCode());
        this.put("Microsoft.MSAL.spe_ring", exception.getSpeRing());
        this.put("Microsoft.MSAL.error_description", exception.getMessage());
        this.put("Microsoft.MSAL.rt_age", exception.getRefreshTokenAge());
        this.put("_is_successful", "false");
        return this;
    }

    public BrokerEndEvent putErrorCode(@NonNull String errorCode) {
        this.put("Microsoft.MSAL.api_error_code", errorCode);
        return this;
    }

    public BrokerEndEvent putErrorDescription(@NonNull String errorDescription) {
        this.put("Microsoft.MSAL.error_description", errorDescription);
        return this;
    }
}

