/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.events;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;

public class ApiEndEvent
extends BaseEvent {
    public ApiEndEvent() {
        this.names("api_end_event");
        this.types("Microsoft.MSAL.api_event");
    }

    public ApiEndEvent putResult(@NonNull AcquireTokenResult result) {
        this.put("_is_successful", result.getSucceeded().toString());
        if (null != result.getLocalAuthenticationResult()) {
            this.put("Microsoft.MSAL.user_id", result.getLocalAuthenticationResult().getUniqueId());
            this.put("Microsoft.MSAL.tenant_id", result.getLocalAuthenticationResult().getTenantId());
            this.put("Microsoft.MSAL.spe_ring", result.getLocalAuthenticationResult().getSpeRing());
            this.put("Microsoft.MSAL.rt_age", result.getLocalAuthenticationResult().getRefreshTokenAge());
        }
        return this;
    }

    public ApiEndEvent putException(@NonNull Exception exception) {
        BaseException adaptedException = ExceptionAdapter.baseExceptionFromException(exception);
        if (adaptedException instanceof UserCancelException) {
            this.put("Microsoft.MSAL.user_cancel", "true");
        }
        this.put("Microsoft.MSAL.server_error_code", adaptedException.getCliTelemErrorCode());
        this.put("Microsoft.MSAL.server_sub_error_code", adaptedException.getCliTelemSubErrorCode());
        this.put("Microsoft.MSAL.api_error_code", adaptedException.getErrorCode());
        this.put("Microsoft.MSAL.spe_ring", adaptedException.getSpeRing());
        this.put("Microsoft.MSAL.error_description", adaptedException.getMessage());
        this.put("Microsoft.MSAL.rt_age", adaptedException.getRefreshTokenAge());
        this.put("_is_successful", "false");
        return this;
    }

    public ApiEndEvent putApiId(@NonNull String apiId) {
        this.put("Microsoft.MSAL.api_id", apiId);
        return this;
    }

    @Override
    public ApiEndEvent put(@NonNull String propertyName, @NonNull String propertyValue) {
        super.put(propertyName, propertyValue);
        return this;
    }

    public ApiEndEvent isApiCallSuccessful(Boolean isSuccessful) {
        this.put("_is_successful", isSuccessful.toString());
        return this;
    }

    public ApiEndEvent putApiErrorCode(@NonNull String errorCode) {
        this.put("Microsoft.MSAL.api_error_code", errorCode);
        return this;
    }
}

