/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.controllers.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.controllers.LoadAccountCommand;
import com.microsoft.identity.common.internal.controllers.RemoveAccountCommand;
import com.microsoft.identity.common.internal.controllers.TokenCommand;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ApiDispatcher {
    private static final String TAG = ApiDispatcher.class.getSimpleName();
    private static final ExecutorService sInteractiveExecutor = Executors.newSingleThreadExecutor();
    private static final ExecutorService sSilentExecutor = Executors.newCachedThreadPool();
    private static final Object sLock = new Object();
    private static InteractiveTokenCommand sCommand = null;

    public static void getAccounts(final @NonNull LoadAccountCommand command) {
        String methodName = ":getAccounts";
        Logger.verbose(TAG + ":getAccounts", "Beginning load accounts.");
        sSilentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String correlationId = ApiDispatcher.initializeDiagnosticContext();
                Object result = null;
                BaseException baseException = null;
                Handler handler = new Handler(Looper.getMainLooper());
                try {
                    result = command.execute();
                }
                catch (Exception e) {
                    Logger.errorPII(TAG + ":getAccounts", "Silent request failed with Exception", e);
                    baseException = ExceptionAdapter.baseExceptionFromException(e);
                }
                if (baseException != null) {
                    final BaseException finalException = baseException;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onError(finalException);
                        }
                    });
                } else {
                    Object finalAccountsList = result;
                    handler.post(new Runnable((List)finalAccountsList){
                        final /* synthetic */ List val$finalAccountsList;
                        {
                            this.val$finalAccountsList = list;
                        }

                        @Override
                        public void run() {
                            command.getCallback().onTaskCompleted(this.val$finalAccountsList);
                        }
                    });
                }
                Telemetry.getInstance().flush(correlationId);
            }
        });
    }

    public static void removeAccount(final @NonNull RemoveAccountCommand command) {
        String methodName = ":removeAccount";
        Logger.verbose(TAG + ":removeAccount", "Beginning remove account.");
        sSilentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String correlationId = ApiDispatcher.initializeDiagnosticContext();
                boolean result = false;
                BaseException baseException = null;
                Handler handler = new Handler(Looper.getMainLooper());
                try {
                    result = command.execute();
                }
                catch (Exception e) {
                    Logger.errorPII(TAG + ":removeAccount", "Silent request failed with Exception", e);
                    baseException = ExceptionAdapter.baseExceptionFromException(e);
                }
                if (baseException != null) {
                    final BaseException finalException = baseException;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onError(finalException);
                        }
                    });
                } else {
                    final boolean finalResult = result;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onTaskCompleted(finalResult);
                        }
                    });
                }
                Telemetry.getInstance().flush(correlationId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final InteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Logger.info(TAG + ":beginInteractive", "Beginning interactive request");
        Object object = sLock;
        synchronized (object) {
            command.getParameters().getAppContext().sendBroadcast(new Intent("cancel_interactive_request_action"));
            sInteractiveExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String correlationId = ApiDispatcher.initializeDiagnosticContext();
                    if (command.mParameters instanceof AcquireTokenOperationParameters) {
                        ApiDispatcher.logInteractiveRequestParameters(":beginInteractive", (AcquireTokenOperationParameters)command.mParameters);
                    }
                    AcquireTokenResult result = null;
                    BaseException baseException = null;
                    try {
                        sCommand = command;
                        result = command.execute();
                    }
                    catch (Exception e) {
                        Logger.errorPII(TAG + ":beginInteractive", "Interactive request failed with Exception", e);
                        baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
                    }
                    finally {
                        sCommand = null;
                    }
                    Handler handler = new Handler(Looper.getMainLooper());
                    if (baseException != null) {
                        final BaseException finalException = baseException;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onError(finalException);
                            }
                        });
                    } else if (null != result && result.getSucceeded().booleanValue()) {
                        final ILocalAuthenticationResult authenticationResult = result.getLocalAuthenticationResult();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onSuccess(authenticationResult);
                            }
                        });
                    } else {
                        baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
                        final BaseException finalException = baseException;
                        if (finalException instanceof UserCancelException) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onCancel();
                                }
                            });
                        } else {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onError(finalException);
                                }
                            });
                        }
                    }
                    Telemetry.getInstance().flush(correlationId);
                }
            });
        }
    }

    private static void logInteractiveRequestParameters(String methodName, AcquireTokenOperationParameters params) {
        Logger.info(TAG + methodName, "Requested " + params.getScopes().size() + " scopes");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String string : params.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + string);
        }
        Logger.infoPII(TAG + methodName, "----");
        Logger.infoPII(TAG + methodName, "ClientId: [" + params.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "RedirectUri: [" + params.getRedirectUri() + "]");
        Logger.infoPII(TAG + methodName, "Login hint: [" + params.getLoginHint() + "]");
        if (null != params.getExtraQueryStringParameters()) {
            Logger.infoPII(TAG + methodName, "Extra query params:");
            for (Pair pair : params.getExtraQueryStringParameters()) {
                Logger.infoPII(TAG + methodName, "\t\"" + (String)pair.first + "\":\"" + (String)pair.second + "\"");
            }
        }
        if (null != params.getExtraScopesToConsent()) {
            Logger.infoPII(TAG + methodName, "Extra scopes to consent:");
            for (String string : params.getExtraScopesToConsent()) {
                Logger.infoPII(TAG + methodName, "\t" + string);
            }
        }
        Logger.info(TAG + methodName, "Using authorization agent: " + params.getAuthorizationAgent().toString());
        if (null != params.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + params.getAccount().getHomeAccountId());
        }
    }

    private static void logSilentRequestParams(String methodName, AcquireTokenSilentOperationParameters parameters) {
        Logger.infoPII(TAG + methodName, "ClientId: [" + parameters.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String scope : parameters.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + scope);
        }
        Logger.infoPII(TAG + methodName, "----");
        if (null != parameters.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + parameters.getAccount().getHomeAccountId());
        }
        Logger.info(TAG + methodName, "Force refresh? [" + parameters.getForceRefresh() + "]");
    }

    public static void completeInteractive(int requestCode, int resultCode, Intent data) {
        String methodName = ":completeInteractive";
        if (sCommand != null) {
            sCommand.notify(requestCode, resultCode, data);
        } else {
            Logger.warn(TAG + ":completeInteractive", "sCommand is null, No interactive call in progress to complete.");
        }
    }

    public static void submitSilent(final TokenCommand command) {
        String methodName = ":submitSilent";
        Logger.info(TAG + ":submitSilent", "Beginning silent request");
        sSilentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String correlationId = ApiDispatcher.initializeDiagnosticContext();
                if (command.mParameters instanceof AcquireTokenSilentOperationParameters) {
                    ApiDispatcher.logSilentRequestParams(":submitSilent", (AcquireTokenSilentOperationParameters)command.mParameters);
                }
                AcquireTokenResult result = null;
                BaseException baseException = null;
                try {
                    result = command.execute();
                }
                catch (Exception e) {
                    Logger.errorPII(TAG + ":submitSilent", "Silent request failed with Exception", e);
                    baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
                }
                Handler handler = new Handler(Looper.getMainLooper());
                if (baseException != null) {
                    final BaseException finalException = baseException;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onError(finalException);
                        }
                    });
                } else if (null != result && result.getSucceeded().booleanValue()) {
                    final ILocalAuthenticationResult authenticationResult = result.getLocalAuthenticationResult();
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onSuccess(authenticationResult);
                        }
                    });
                } else {
                    baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
                    final BaseException finalException = baseException;
                    if (finalException instanceof UserCancelException) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onCancel();
                            }
                        });
                    } else {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onError(finalException);
                            }
                        });
                    }
                }
                Telemetry.getInstance().flush(correlationId);
            }
        });
    }

    public static String initializeDiagnosticContext() {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = UUID.randomUUID().toString();
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":initializeDiagnosticContext", "Initialized new DiagnosticContext");
        return correlationId;
    }
}

