/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class BrowserDescriptor
implements Serializable {
    @SerializedName(value="browser_package_name")
    private String mPackageName;
    @SerializedName(value="browser_signature_hashes")
    private Set<String> mSignatureHashes;
    @SerializedName(value="browser_version_lower_bound")
    private String mVersionLowerBound;
    @SerializedName(value="browser_version_upper_bound")
    private String mVersionUpperBound;

    public BrowserDescriptor(@NonNull String packageName, @NonNull Set<String> signatureHashes, @Nullable String versionLowerBound, @Nullable String versionUpperBound) {
        this.mPackageName = packageName;
        this.mSignatureHashes = signatureHashes;
        this.mVersionLowerBound = versionLowerBound;
        this.mVersionUpperBound = versionUpperBound;
    }

    public BrowserDescriptor(@NonNull String packageName, @NonNull String signatureHash, @Nullable String versionLowerBound, @Nullable String versionUpperBound) {
        this.mPackageName = packageName;
        this.mSignatureHashes = Collections.singleton(signatureHash);
        this.mVersionLowerBound = versionLowerBound;
        this.mVersionUpperBound = versionUpperBound;
    }

    public boolean matches(@NonNull Browser browser) {
        if (!this.mPackageName.equalsIgnoreCase(browser.getPackageName())) {
            return false;
        }
        if (!this.mSignatureHashes.equals(browser.getSignatureHashes())) {
            return false;
        }
        if (!StringUtil.isEmpty(this.mVersionLowerBound) && StringUtil.compareSemanticVersion(browser.getVersion(), this.mVersionLowerBound) == -1) {
            return false;
        }
        return StringUtil.isEmpty(this.mVersionUpperBound) || StringUtil.compareSemanticVersion(browser.getVersion(), this.mVersionUpperBound) != 1;
    }
}

