/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.app.Activity;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.google.gson.annotations.Expose;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.BrowserDescriptor;
import java.util.HashMap;
import java.util.List;

public class AcquireTokenOperationParameters
extends OperationParameters {
    private transient Activity mActivity;
    private transient Fragment mFragment;
    private String mLoginHint;
    @Expose
    private boolean webViewZoomControlsEnabled;
    @Expose
    private boolean webViewZoomEnabled;
    @Expose
    private List<Pair<String, String>> mExtraQueryStringParameters;
    @Expose
    private List<String> mExtraScopesToConsent;
    @Expose
    private OpenIdConnectPromptParameter mOpenIdConnectPromptParameter;
    private transient HashMap<String, String> mRequestHeaders;
    private boolean mBrokerBrowserSupportEnabled;
    @Expose
    private AuthorizationAgent mAuthorizationAgent;

    public AuthorizationAgent getAuthorizationAgent() {
        return this.mAuthorizationAgent;
    }

    public void setAuthorizationAgent(@Nullable AuthorizationAgent authorizationAgent) {
        this.mAuthorizationAgent = authorizationAgent;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public void setActivity(@NonNull Activity activity) {
        this.mActivity = activity;
    }

    public Fragment getFragment() {
        return this.mFragment;
    }

    public void setFragment(@NonNull Fragment fragment) {
        this.mFragment = fragment;
    }

    public List<Pair<String, String>> getExtraQueryStringParameters() {
        return this.mExtraQueryStringParameters;
    }

    public void setExtraQueryStringParameters(@Nullable List<Pair<String, String>> mExtraQueryStringParameters) {
        this.mExtraQueryStringParameters = mExtraQueryStringParameters;
    }

    public List<String> getExtraScopesToConsent() {
        return this.mExtraScopesToConsent;
    }

    public void setExtraScopesToConsent(@Nullable List<String> mExtraScopesToConsent) {
        this.mExtraScopesToConsent = mExtraScopesToConsent;
    }

    public void setLoginHint(@Nullable String loginHint) {
        this.mLoginHint = loginHint != null ? loginHint.trim() : loginHint;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public OpenIdConnectPromptParameter getOpenIdConnectPromptParameter() {
        return this.mOpenIdConnectPromptParameter;
    }

    public void setOpenIdConnectPromptParameter(@Nullable OpenIdConnectPromptParameter openIdConnectPromptParameter) {
        this.mOpenIdConnectPromptParameter = openIdConnectPromptParameter;
    }

    public HashMap<String, String> getRequestHeaders() {
        return this.mRequestHeaders;
    }

    public void setRequestHeaders(@Nullable HashMap<String, String> requestHeaders) {
        this.mRequestHeaders = requestHeaders;
    }

    @Override
    public void setBrowserSafeList(List<BrowserDescriptor> browserSafeList) {
        this.mBrowserSafeList = browserSafeList;
    }

    public boolean isBrokerBrowserSupportEnabled() {
        return this.mBrokerBrowserSupportEnabled;
    }

    public void setBrokerBrowserSupportEnabled(boolean brokerBrowserSupportEnabled) {
        this.mBrokerBrowserSupportEnabled = brokerBrowserSupportEnabled;
    }

    public void setWebViewZoomControlsEnabled(boolean webViewZoomControlsEnabled) {
        this.webViewZoomControlsEnabled = webViewZoomControlsEnabled;
    }

    public void setWebViewZoomEnabled(boolean webViewZoomEnabled) {
        this.webViewZoomEnabled = webViewZoomEnabled;
    }

    public boolean isWebViewZoomEnabled() {
        return this.webViewZoomEnabled;
    }

    public boolean isWebViewZoomControlsEnabled() {
        return this.webViewZoomControlsEnabled;
    }

    @Override
    public List<BrowserDescriptor> getBrowserSafeList() {
        return this.mBrowserSafeList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AcquireTokenOperationParameters)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AcquireTokenOperationParameters that = (AcquireTokenOperationParameters)o;
        if (this.mLoginHint != null ? !this.mLoginHint.equals(that.mLoginHint) : that.mLoginHint != null) {
            return false;
        }
        if (this.mExtraQueryStringParameters != null ? !this.mExtraQueryStringParameters.equals(that.mExtraQueryStringParameters) : that.mExtraQueryStringParameters != null) {
            return false;
        }
        if (this.mExtraScopesToConsent != null ? !this.mExtraScopesToConsent.equals(that.mExtraScopesToConsent) : that.mExtraScopesToConsent != null) {
            return false;
        }
        return this.mOpenIdConnectPromptParameter == that.mOpenIdConnectPromptParameter;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mLoginHint != null ? this.mLoginHint.hashCode() : 0);
        result = 31 * result + (this.mExtraQueryStringParameters != null ? this.mExtraQueryStringParameters.hashCode() : 0);
        result = 31 * result + (this.mExtraScopesToConsent != null ? this.mExtraScopesToConsent.hashCode() : 0);
        result = 31 * result + (this.mOpenIdConnectPromptParameter != null ? this.mOpenIdConnectPromptParameter.hashCode() : 0);
        return result;
    }
}

