/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.controllers.CommandDispatcher;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.UiStartEvent;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.webview.AzureActiveDirectoryWebViewClient;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.WebViewUtil;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationFragment
extends Fragment {
    @VisibleForTesting
    static final String KEY_AUTH_INTENT = "authIntent";
    @VisibleForTesting
    static final String KEY_BROWSER_FLOW_STARTED = "browserFlowStarted";
    @VisibleForTesting
    static final String KEY_PKEYAUTH_STATUS = "pkeyAuthStatus";
    @VisibleForTesting
    static final String KEY_AUTH_REQUEST_URL = "authRequestUrl";
    @VisibleForTesting
    static final String KEY_AUTH_REDIRECT_URI = "authRedirectUri";
    @VisibleForTesting
    static final String KEY_AUTH_AUTHORIZATION_AGENT = "authorizationAgent";
    @VisibleForTesting
    static final String KEY_REQUEST_HEADERS = "requestHeaders";
    static final String WEB_VIEW_ZOOM_CONTROLS_ENABLED = "com.microsoft.identity.web.view.zoom.controls.enabled";
    static final String WEB_VIEW_ZOOM_ENABLED = "com.microsoft.identity.web.view.zoom.enabled";
    public static final String CANCEL_INTERACTIVE_REQUEST_ACTION = "cancel_interactive_request_action";
    private static final String TAG = AuthorizationFragment.class.getSimpleName();
    private Bundle mInstanceState;
    private static Class<?> sCallingActivityClass;
    private static String sCustomTabResponseUri;
    private boolean mBrowserFlowStarted = false;
    private WebView mWebView;
    private ProgressBar mProgressBar;
    private Intent mAuthIntent;
    private boolean mPkeyAuthStatus = false;
    private String mAuthorizationRequestUrl;
    private String mRedirectUri;
    private HashMap<String, String> mRequestHeaders;
    private AuthorizationAgent mAuthorizationAgent;
    private boolean mAuthResultSent = false;
    private boolean webViewZoomControlsEnabled;
    private boolean webViewZoomEnabled;
    private BroadcastReceiver mCancelRequestReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Logger.info(TAG, "Received Authorization flow cancel request from SDK");
            Telemetry.emit(new UiEndEvent().isUserCancelled());
            AuthorizationFragment.this.sendResult(2008, new Intent());
            AuthorizationFragment.this.finish();
        }
    };

    private Intent createResultIntent(@NonNull String url) {
        Intent resultIntent = new Intent();
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        if (!StringExtensions.isNullOrBlank((String)parameters.get("error"))) {
            Logger.info(TAG, "Sending intent to cancel authentication activity");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", (String)parameters.get("error"));
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorSubCode", (String)parameters.get("error_subcode"));
            if (!StringUtil.isEmpty((String)parameters.get("error_description"))) {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get("error_description"));
            } else {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get("error_subcode"));
            }
        } else {
            Logger.info(TAG, "It is pointing to redirect. Final url can be processed to get the code or error.");
            resultIntent.putExtra("com.microsoft.identity.client.final.url", url);
        }
        return resultIntent;
    }

    public static Intent createCustomTabResponseIntent(Context context, String responseUri) {
        sCustomTabResponseUri = responseUri;
        Intent intent = new Intent(context, sCallingActivityClass);
        intent.addFlags(0x24000000);
        return intent;
    }

    public void setInstanceState(@NonNull Bundle instanceStateBundle) {
        this.mInstanceState = instanceStateBundle;
    }

    private void finish() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof AuthorizationActivity) {
            activity.finish();
        } else {
            this.getFragmentManager().beginTransaction().setTransitionStyle(4099).remove((Fragment)this).commit();
        }
    }

    private void extractState(Bundle state) {
        if (state == null) {
            Logger.warn(TAG, "No stored state. Unable to handle response");
            this.finish();
            return;
        }
        AuthorizationFragment.setDiagnosticContextForNewThread(state.getString("correlation_id"));
        this.mAuthIntent = (Intent)state.getParcelable(KEY_AUTH_INTENT);
        this.mBrowserFlowStarted = state.getBoolean(KEY_BROWSER_FLOW_STARTED, false);
        this.mPkeyAuthStatus = state.getBoolean(KEY_PKEYAUTH_STATUS, false);
        this.mAuthorizationRequestUrl = state.getString(KEY_AUTH_REQUEST_URL);
        this.mRedirectUri = state.getString(KEY_AUTH_REDIRECT_URI);
        this.mRequestHeaders = this.getRequestHeaders(state);
        this.mAuthorizationAgent = (AuthorizationAgent)((Object)state.getSerializable(KEY_AUTH_AUTHORIZATION_AGENT));
        this.webViewZoomEnabled = state.getBoolean(WEB_VIEW_ZOOM_ENABLED, true);
        this.webViewZoomControlsEnabled = state.getBoolean(WEB_VIEW_ZOOM_CONTROLS_ENABLED, true);
    }

    private HashMap<String, String> getRequestHeaders(Bundle state) {
        try {
            return (HashMap)state.getSerializable(KEY_REQUEST_HEADERS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        String methodName = "#onCreate";
        super.onCreate(savedInstanceState);
        sCallingActivityClass = this.getActivity().getClass();
        WebViewUtil.setDataDirectorySuffix(this.getActivity().getApplicationContext());
        this.getActivity().getApplicationContext().registerReceiver(this.mCancelRequestReceiver, new IntentFilter(CANCEL_INTERACTIVE_REQUEST_ACTION));
        if (savedInstanceState == null) {
            Logger.verbose(TAG + "#onCreate", "Extract state from the intent bundle.");
            this.extractState(this.mInstanceState);
        } else {
            Logger.verbose(TAG + "#onCreate", "Extract state from the saved bundle.");
            this.extractState(savedInstanceState);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        String methodName = "#onCreateView";
        View view = inflater.inflate(R.layout.common_activity_authentication, container, false);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.common_auth_webview_progressbar);
        Telemetry.emit(new UiStartEvent().putUserAgent(this.mAuthorizationAgent));
        if (this.mAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            AzureActiveDirectoryWebViewClient webViewClient = new AzureActiveDirectoryWebViewClient((Activity)this.getActivity(), new AuthorizationCompletionCallback(), new OnPageLoadedCallback(){

                @Override
                public void onPageLoaded() {
                    AuthorizationFragment.this.mProgressBar.setVisibility(4);
                }
            }, this.mRedirectUri);
            this.setUpWebView(view, webViewClient);
        }
        if (this.mAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            this.mWebView.post(new Runnable(){

                @Override
                public void run() {
                    AuthorizationFragment.this.mWebView.loadUrl("about:blank");
                    Logger.info(TAG + "#onCreateView", "Launching embedded WebView for acquiring auth code.");
                    Logger.infoPII(TAG + "#onCreateView", "The start url is " + AuthorizationFragment.this.mAuthorizationRequestUrl);
                    AuthorizationFragment.this.mWebView.loadUrl(AuthorizationFragment.this.mAuthorizationRequestUrl, (Map)AuthorizationFragment.this.mRequestHeaders);
                    AuthorizationFragment.this.mProgressBar.setVisibility(0);
                }
            });
        }
        return view;
    }

    private static String setDiagnosticContextForNewThread(String correlationId) {
        String methodName = ":setDiagnosticContextForAuthorizationActivity";
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":setDiagnosticContextForAuthorizationActivity", "Initializing diagnostic context for AuthorizationActivity");
        return correlationId;
    }

    public void onResume() {
        super.onResume();
        if (this.mAuthorizationAgent == AuthorizationAgent.DEFAULT || this.mAuthorizationAgent == AuthorizationAgent.BROWSER) {
            if (!this.mBrowserFlowStarted) {
                this.mBrowserFlowStarted = true;
                if (this.mAuthIntent != null) {
                    this.startActivity(this.mAuthIntent);
                } else {
                    Intent resultIntent = new Intent();
                    resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)new ClientException("Authorization intent is null."));
                    this.sendResult(2005, resultIntent);
                    this.finish();
                }
            } else if (!StringUtil.isEmpty(sCustomTabResponseUri)) {
                this.completeAuthorizationInBrowserFlow(sCustomTabResponseUri);
            } else {
                this.cancelAuthorization();
            }
        }
    }

    public void onStop() {
        String methodName = ":onStop";
        if (!this.mAuthResultSent && this.getActivity().isFinishing()) {
            Logger.info(TAG + ":onStop", "Hosting Activity is destroyed before Auth request is completed, sending request cancel");
            Telemetry.emit(new UiEndEvent().isUserCancelled());
            this.sendResult(2008, new Intent());
        }
        super.onStop();
    }

    public void onDestroy() {
        String methodName = "#onDestroy";
        Logger.info(TAG + "#onDestroy", "");
        if (!this.mAuthResultSent) {
            Logger.info(TAG + "#onDestroy", "Hosting Activity is destroyed before Auth request is completed, sending request cancel");
            Telemetry.emit(new UiEndEvent().isUserCancelled());
            this.sendResult(2008, new Intent());
        }
        this.getActivity().getApplicationContext().unregisterReceiver(this.mCancelRequestReceiver);
        super.onDestroy();
    }

    private void sendResult(int resultCode, Intent resultIntent) {
        Logger.info(TAG, "Sending result from Authorization Activity, resultCode: " + resultCode);
        CommandDispatcher.completeInteractive(1001, resultCode, resultIntent);
        this.mAuthResultSent = true;
    }

    private void completeAuthorizationInBrowserFlow(@NonNull String customTabResponseUri) {
        Logger.info(TAG, null, "Received redirect from customTab/browser.");
        Intent resultIntent = this.createResultIntent(customTabResponseUri);
        HashMap<String, String> urlQueryParameters = StringExtensions.getUrlParameters(customTabResponseUri);
        String userName = (String)urlQueryParameters.get("username");
        if (this.isDeviceRegisterRedirect(customTabResponseUri) && !TextUtils.isEmpty((CharSequence)userName)) {
            Logger.info(TAG, " Device needs to be registered, sending BROWSER_CODE_DEVICE_REGISTER");
            Logger.infoPII(TAG, "Device Registration triggered for user: " + userName);
            resultIntent.putExtra("username", userName);
            this.sendResult(2007, resultIntent);
            return;
        }
        if (urlQueryParameters.containsKey("app_link")) {
            String appLink = (String)urlQueryParameters.get("app_link");
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)appLink));
            this.startActivity(browserIntent);
            Logger.info(TAG, "Return to caller with BROKER_REQUEST_RESUME, and waiting for result.");
            this.sendResult(2006, resultIntent);
        } else if (!StringUtil.isEmpty(resultIntent.getStringExtra("com.microsoft.identity.client.final.url"))) {
            this.sendResult(2003, resultIntent);
            Telemetry.emit(new UiEndEvent().isUiComplete());
        } else if (!StringUtil.isEmpty(resultIntent.getStringExtra("com.microsoft.aad.adal:BrowserErrorSubCode")) && resultIntent.getStringExtra("com.microsoft.aad.adal:BrowserErrorSubCode").equalsIgnoreCase("cancel")) {
            Telemetry.emit(new UiEndEvent().isUserCancelled());
            this.sendResult(2008, resultIntent);
        } else {
            Telemetry.emit(new UiEndEvent().isUiCancelled());
            this.sendResult(2002, resultIntent);
        }
        this.finish();
    }

    private void cancelAuthorization() {
        Logger.info(TAG, "Authorization flow is canceled by user");
        Intent resultIntent = new Intent();
        resultIntent.setFlags(0x4000000);
        this.sendResult(2001, resultIntent);
        Telemetry.emit(new UiEndEvent().isUserCancelled());
        this.finish();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_AUTH_INTENT, (Parcelable)this.mAuthIntent);
        outState.putBoolean(KEY_BROWSER_FLOW_STARTED, this.mBrowserFlowStarted);
        outState.putBoolean(KEY_PKEYAUTH_STATUS, this.mPkeyAuthStatus);
        outState.putSerializable(KEY_AUTH_AUTHORIZATION_AGENT, (Serializable)((Object)this.mAuthorizationAgent));
        outState.putString(KEY_AUTH_REDIRECT_URI, this.mRedirectUri);
        outState.putString(KEY_AUTH_REQUEST_URL, this.mAuthorizationRequestUrl);
        outState.putBoolean(WEB_VIEW_ZOOM_CONTROLS_ENABLED, this.webViewZoomControlsEnabled);
        outState.putBoolean(WEB_VIEW_ZOOM_ENABLED, this.webViewZoomEnabled);
    }

    public boolean onBackPressed() {
        Logger.info(TAG, "Back button is pressed");
        if (null != this.mWebView && this.mWebView.canGoBack()) {
            int BACK_PRESSED_STEPS = -2;
            if (!this.mWebView.canGoBackOrForward(-2)) {
                this.cancelAuthorization();
            } else {
                this.mWebView.goBack();
            }
            return true;
        }
        return false;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void setUpWebView(@NonNull View view, @NonNull AzureActiveDirectoryWebViewClient webViewClient) {
        this.mWebView = (WebView)view.findViewById(R.id.common_auth_webview);
        WebSettings userAgentSetting = this.mWebView.getSettings();
        String userAgent = userAgentSetting.getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(this.webViewZoomControlsEnabled);
        this.mWebView.getSettings().setSupportZoom(this.webViewZoomEnabled);
        this.mWebView.setVisibility(4);
        this.mWebView.setWebViewClient((WebViewClient)webViewClient);
    }

    private boolean isDeviceRegisterRedirect(@NonNull String redirectUrl) {
        try {
            URI uri = new URI(redirectUrl);
            return uri.getScheme().equalsIgnoreCase("msauth") && uri.getHost().equalsIgnoreCase("wpj");
        }
        catch (URISyntaxException e) {
            Logger.error(TAG, "Uri construction failed", e);
            return false;
        }
    }

    class AuthorizationCompletionCallback
    implements IAuthorizationCompletionCallback {
        AuthorizationCompletionCallback() {
        }

        @Override
        public void onChallengeResponseReceived(int returnCode, Intent responseIntent) {
            Logger.info(TAG, null, "onChallengeResponseReceived:" + returnCode);
            AuthorizationFragment.this.sendResult(returnCode, responseIntent);
            AuthorizationFragment.this.finish();
        }

        @Override
        public void setPKeyAuthStatus(boolean status) {
            AuthorizationFragment.this.mPkeyAuthStatus = status;
            Logger.info(TAG, null, "setPKeyAuthStatus:" + status);
        }
    }
}

