/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import java.io.Serializable;
import java.util.HashMap;

public final class AuthorizationActivity
extends FragmentActivity {
    private AuthorizationFragment mFragment;

    public static Intent createStartIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent, boolean webViewZoomEnabled, boolean webViewZoomControlsEnabled) {
        Intent intent = new Intent(context, AuthorizationActivity.class);
        intent.putExtra("authIntent", (Parcelable)authIntent);
        intent.putExtra("authRequestUrl", requestUrl);
        intent.putExtra("authRedirectUri", redirectUri);
        intent.putExtra("requestHeaders", requestHeaders);
        intent.putExtra("authorizationAgent", (Serializable)((Object)authorizationAgent));
        intent.putExtra("com.microsoft.identity.web.view.zoom.controls.enabled", webViewZoomControlsEnabled);
        intent.putExtra("com.microsoft.identity.web.view.zoom.enabled", webViewZoomEnabled);
        intent.putExtra("correlation_id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        return intent;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.authorization_activity);
        this.mFragment = new AuthorizationFragment();
        this.mFragment.setInstanceState(this.getIntent().getExtras());
        this.getSupportFragmentManager().beginTransaction().setTransitionStyle(4099).replace(R.id.authorization_activity_content, (Fragment)this.mFragment).commit();
    }

    public void onBackPressed() {
        if (!this.mFragment.onBackPressed()) {
            super.onBackPressed();
        }
    }
}

