/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.BrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.ui.webview.EmbeddedWebViewAuthorizationStrategy;

public class AuthorizationStrategyFactory<GenericAuthorizationStrategy extends AuthorizationStrategy> {
    private static final String TAG = AuthorizationStrategyFactory.class.getSimpleName();
    private static AuthorizationStrategyFactory sInstance = null;

    public static AuthorizationStrategyFactory getInstance() {
        if (sInstance == null) {
            sInstance = new AuthorizationStrategyFactory();
        }
        return sInstance;
    }

    public GenericAuthorizationStrategy getAuthorizationStrategy(@NonNull AcquireTokenOperationParameters parameters) {
        AuthorizationAgent validatedAuthorizationAgent = this.validAuthorizationAgent(parameters.getAuthorizationAgent(), parameters.getAppContext());
        boolean isBrokerRequest = parameters instanceof BrokerAcquireTokenOperationParameters;
        if (validatedAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            Logger.info(TAG, "Use webView for authorization.");
            return (GenericAuthorizationStrategy)new EmbeddedWebViewAuthorizationStrategy(parameters.getAppContext(), parameters.getActivity(), parameters.getFragment());
        }
        if (validatedAuthorizationAgent == AuthorizationAgent.DEFAULT) {
            block4: {
                try {
                    BrowserSelector.select(parameters.getAppContext(), parameters.getBrowserSafeList());
                }
                catch (ClientException exception) {
                    Logger.info(TAG, "No supported browser available found. Fallback to the webView authorization agent.");
                    if (!exception.getErrorCode().equalsIgnoreCase("No available browser installed on the device.")) break block4;
                    return (GenericAuthorizationStrategy)new EmbeddedWebViewAuthorizationStrategy(parameters.getAppContext(), parameters.getActivity(), parameters.getFragment());
                }
            }
            Logger.info(TAG, "Use browser for authorization.");
            BrowserAuthorizationStrategy browserAuthorizationStrategy = new BrowserAuthorizationStrategy(parameters.getAppContext(), parameters.getActivity(), parameters.getFragment(), isBrokerRequest);
            browserAuthorizationStrategy.setBrowserSafeList(parameters.getBrowserSafeList());
            return (GenericAuthorizationStrategy)browserAuthorizationStrategy;
        }
        Logger.info(TAG, "Use browser for authorization.");
        BrowserAuthorizationStrategy browserAuthorizationStrategy = new BrowserAuthorizationStrategy(parameters.getAppContext(), parameters.getActivity(), parameters.getFragment(), isBrokerRequest);
        browserAuthorizationStrategy.setBrowserSafeList(parameters.getBrowserSafeList());
        return (GenericAuthorizationStrategy)browserAuthorizationStrategy;
    }

    private AuthorizationAgent validAuthorizationAgent(AuthorizationAgent agent, Context context) {
        if (agent != AuthorizationAgent.WEBVIEW && BrowserSelector.getAllBrowsers(context).isEmpty()) {
            Logger.verbose(TAG, "Unable to use browser to do the authorization because No available browser installed on the device. Use embedded webView instead.");
            return AuthorizationAgent.WEBVIEW;
        }
        return agent;
    }
}

