/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;

public abstract class AuthorizationStrategy<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest> {
    public static final int BROWSER_FLOW = 1001;
    public static final String REQUEST_URL_KEY = "com.microsoft.identity.request.url.key";
    public static final String REQUEST_ID = "com.microsoft.identity.request.id";
    public static final String CUSTOM_TAB_REDIRECT = "com.microsoft.identity.customtab.redirect";
    public static final String AUTHORIZATION_FINAL_URL = "com.microsoft.identity.client.final.url";
    public static final String RESULT_CODE = "com.microsoft.identity.client.result.code";
    public static final String REQUEST_CODE = "com.microsoft.identity.client.request.code";
    private WeakReference<Context> mReferencedApplicationContext;
    private WeakReference<Activity> mReferencedActivity;
    private WeakReference<Fragment> mReferencedFragment;

    public AuthorizationStrategy(@NonNull Context applicationContext, @NonNull Activity activity, @Nullable Fragment fragment) {
        this.mReferencedApplicationContext = new WeakReference<Context>(applicationContext);
        this.mReferencedActivity = new WeakReference<Activity>(activity);
        this.mReferencedFragment = new WeakReference<Fragment>(fragment);
    }

    protected Context getApplicationContext() {
        return (Context)this.mReferencedApplicationContext.get();
    }

    protected void launchIntent(@NonNull Intent intent) {
        Fragment fragment = (Fragment)this.mReferencedFragment.get();
        if (fragment != null) {
            AuthorizationFragment authFragment = new AuthorizationFragment();
            authFragment.setInstanceState(intent.getExtras());
            fragment.getFragmentManager().beginTransaction().setTransitionStyle(4099).add(fragment.getId(), (Fragment)authFragment, AuthorizationFragment.class.getName()).commit();
            return;
        }
        ((Activity)this.mReferencedActivity.get()).startActivity(intent);
    }

    public abstract Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest var1, GenericOAuth2Strategy var2) throws ClientException, UnsupportedEncodingException;

    public abstract void completeAuthorization(int var1, int var2, Intent var3);
}

