/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.Map;

public class SharedPreferencesFileManager
implements ISharedPreferencesFileManager {
    private static final String TAG = SharedPreferencesFileManager.class.getSimpleName();
    private final String mSharedPreferencesFileName;
    private final SharedPreferences mSharedPreferences;
    private final IStorageHelper mStorageHelper;

    public SharedPreferencesFileManager(Context context, String name) {
        Logger.verbose(TAG, "Init: " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, 0);
        this.mStorageHelper = null;
    }

    public SharedPreferencesFileManager(Context context, String name, int operatingMode) {
        Logger.verbose(TAG, "Init with operating mode: " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, operatingMode);
        this.mStorageHelper = null;
    }

    public SharedPreferencesFileManager(Context context, String name, IStorageHelper storageHelper) {
        Logger.verbose(TAG, "Init with storage helper:  " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, 0);
        this.mStorageHelper = storageHelper;
    }

    public SharedPreferencesFileManager(Context context, String name, int operatingMode, IStorageHelper storageHelper) {
        Logger.verbose(TAG, "Init with operating mode and storage helper " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, operatingMode);
        this.mStorageHelper = storageHelper;
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public final void putString(String key, String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        if (null == this.mStorageHelper) {
            editor.putString(key, value);
        } else {
            String encryptedValue = this.encrypt(value);
            editor.putString(key, encryptedValue);
        }
        editor.commit();
    }

    @Override
    @Nullable
    public final String getString(String key) {
        String restoredValue = this.mSharedPreferences.getString(key, null);
        if (null != this.mStorageHelper && !StringExtensions.isNullOrBlank(restoredValue) && StringExtensions.isNullOrBlank(restoredValue = this.decrypt(restoredValue))) {
            this.logWarningAndRemoveKey(key);
        }
        return restoredValue;
    }

    private void logWarningAndRemoveKey(String key) {
        Logger.warn(TAG, "Failed to decrypt value! This usually signals an issue with KeyStore or the provided SecretKeys.");
        this.remove(key);
    }

    @Override
    public final String getSharedPreferencesFileName() {
        return this.mSharedPreferencesFileName;
    }

    @Override
    public final Map<String, String> getAll() {
        Map entries = this.mSharedPreferences.getAll();
        if (null != this.mStorageHelper) {
            Iterator iterator = entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String decryptedValue = this.decrypt((String)entry.getValue());
                if (TextUtils.isEmpty((CharSequence)decryptedValue)) {
                    this.logWarningAndRemoveKey((String)entry.getKey());
                    iterator.remove();
                    continue;
                }
                entry.setValue(decryptedValue);
            }
        }
        return entries;
    }

    @Override
    public final boolean contains(String key) {
        return !TextUtils.isEmpty((CharSequence)this.getString(key));
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public final void clear() {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public void remove(String key) {
        Logger.info(TAG, "Removing cache key");
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.remove(key);
        editor.commit();
        Logger.infoPII(TAG, "Removed cache key [" + key + "]");
    }

    @Nullable
    private String encrypt(@NonNull String clearText) {
        return this.encryptDecryptInternal(clearText, true);
    }

    @Nullable
    private String decrypt(@NonNull String encryptedBlob) {
        return this.encryptDecryptInternal(encryptedBlob, false);
    }

    @Nullable
    private String encryptDecryptInternal(@NonNull String inputText, boolean encrypt) {
        String result;
        String methodName = "encryptDecryptInternal";
        try {
            result = encrypt ? this.mStorageHelper.encrypt(inputText) : this.mStorageHelper.decrypt(inputText);
        }
        catch (IOException | GeneralSecurityException e) {
            Logger.error(TAG + ":" + "encryptDecryptInternal", "Failed to " + (encrypt ? "encrypt" : "decrypt") + " value", encrypt ? null : e);
            result = null;
        }
        return result;
    }
}

