/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.request.OperationParameters;
import java.io.IOException;

public class AcquireTokenSilentOperationParameters
extends OperationParameters {
    private static final String TAG = AcquireTokenSilentOperationParameters.class.getSimpleName();
    private static final Object sLock = new Object();
    private transient RefreshTokenRecord mRefreshToken;

    public RefreshTokenRecord getRefreshToken() {
        return this.mRefreshToken;
    }

    public void setRefreshToken(@Nullable RefreshTokenRecord refreshToken) {
        this.mRefreshToken = refreshToken;
    }

    @Override
    public void validate() throws ArgumentException {
        super.validate();
        if (this.mAccount == null) {
            Logger.warn(TAG, "The account set on silent operation parameters is NULL.");
        } else if (!this.authorityMatchesAccountEnvironment()) {
            throw new ArgumentException("acquireTokenSilent", "authority", "Authority passed to silent parameters does not match with the cloud associated to the account.");
        }
    }

    private boolean authorityMatchesAccountEnvironment() {
        String methodName = ":authorityMatchesAccountEnvironment";
        try {
            AzureActiveDirectoryCloud cloud;
            if (!AzureActiveDirectory.isInitialized()) {
                AcquireTokenSilentOperationParameters.performCloudDiscovery();
            }
            return (cloud = AzureActiveDirectory.getAzureActiveDirectoryCloudFromHostName(this.mAccount.getEnvironment())) != null && cloud.getPreferredNetworkHostName().equals(this.getAuthority().getAuthorityURL().getAuthority());
        }
        catch (IOException e) {
            Logger.error(TAG + ":authorityMatchesAccountEnvironment", "Unable to perform cloud discovery", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCloudDiscovery() throws IOException {
        String methodName = ":performCloudDiscovery";
        Logger.verbose(TAG + ":performCloudDiscovery", "Performing cloud discovery...");
        Object object = sLock;
        synchronized (object) {
            AzureActiveDirectory.performCloudDiscovery();
        }
    }
}

