/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.net.Uri;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.platform.Device;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenErrorResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccessToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdProviderConfiguration;
import com.microsoft.identity.common.internal.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.telemetry.CliTelemInfo;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeFactory;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import com.microsoft.identity.common.internal.util.HeaderSerializationUtil;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class MicrosoftStsOAuth2Strategy
extends OAuth2Strategy<MicrosoftStsAccessToken, MicrosoftStsAccount, MicrosoftStsAuthorizationRequest, MicrosoftStsAuthorizationRequest.Builder, AuthorizationStrategy, MicrosoftStsOAuth2Configuration, MicrosoftStsAuthorizationResponse, MicrosoftStsRefreshToken, MicrosoftStsTokenRequest, MicrosoftStsTokenResponse, TokenResult, AuthorizationResult> {
    private static final String TAG = MicrosoftStsOAuth2Strategy.class.getSimpleName();

    public MicrosoftStsOAuth2Strategy(@NonNull MicrosoftStsOAuth2Configuration config) {
        super(config);
        this.setTokenEndpoint(config.getTokenEndpoint().toString());
    }

    @Override
    public AuthorizationResultFactory getAuthorizationResultFactory() {
        return new MicrosoftStsAuthorizationResultFactory();
    }

    @Override
    public String getIssuerCacheIdentifier(@NonNull MicrosoftStsAuthorizationRequest request) {
        String methodName = ":getIssuerCacheIdentifier";
        URL authority = request.getAuthority();
        AzureActiveDirectoryCloud cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authority);
        if (null != cloudEnv) {
            String preferredCacheHostName = cloudEnv.getPreferredCacheHostName();
            Logger.info(TAG + ":getIssuerCacheIdentifier", "Using preferred cache host name...");
            Logger.infoPII(TAG + ":getIssuerCacheIdentifier", "Preferred cache hostname: [" + preferredCacheHostName + "]");
            return preferredCacheHostName;
        }
        return authority.getHost();
    }

    private String getIssuerCacheIdentifierFromAuthority(URL authority) {
        String methodName = ":getIssuerCacheIdentifierFromAuthority";
        AzureActiveDirectoryCloud cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authority);
        if (null != cloudEnv) {
            String preferredCacheHostName = cloudEnv.getPreferredCacheHostName();
            Logger.info(TAG + ":getIssuerCacheIdentifierFromAuthority", "Using preferred cache host name...");
            Logger.infoPII(TAG + ":getIssuerCacheIdentifierFromAuthority", "Preferred cache hostname: [" + preferredCacheHostName + "]");
            return preferredCacheHostName;
        }
        return authority.getHost();
    }

    public String getIssuerCacheIdentifierFromTokenEndpoint() {
        String methodName = ":getIssuerCacheIdentifierFromTokenEndpoint";
        URL authority = null;
        String cacheIdentifier = null;
        try {
            authority = new URL(this.mTokenEndpoint);
        }
        catch (MalformedURLException e) {
            Logger.error(TAG + ":getIssuerCacheIdentifierFromTokenEndpoint", "Getting issuer cache identifier from token endpoint failed due to malformed URL (mTokenEndpoint)...", e);
        }
        if (authority != null) {
            cacheIdentifier = this.getIssuerCacheIdentifierFromAuthority(authority);
        }
        return cacheIdentifier;
    }

    @Override
    public MicrosoftStsAccessToken getAccessTokenFromResponse(@NonNull MicrosoftStsTokenResponse response) {
        String methodName = ":getAccessTokenFromResponse";
        Logger.verbose(TAG + ":getAccessTokenFromResponse", "Getting AT from TokenResponse...");
        return new MicrosoftStsAccessToken(response);
    }

    @Override
    public MicrosoftStsRefreshToken getRefreshTokenFromResponse(@NonNull MicrosoftStsTokenResponse response) {
        String methodName = ":getRefreshTokenFromResponse";
        Logger.verbose(TAG + ":getRefreshTokenFromResponse", "Getting RT from TokenResponse...");
        return new MicrosoftStsRefreshToken(response);
    }

    @Override
    public MicrosoftStsAccount createAccount(@NonNull MicrosoftStsTokenResponse response) {
        String methodName = ":createAccount";
        Logger.verbose(TAG + ":createAccount", "Creating account from TokenResponse...");
        IDToken idToken = null;
        ClientInfo clientInfo = null;
        try {
            idToken = new IDToken(response.getIdToken());
            clientInfo = new ClientInfo(response.getClientInfo());
        }
        catch (ServiceException ccse) {
            Logger.error(TAG + ":createAccount", "Failed to construct IDToken or ClientInfo", null);
            Logger.errorPII(TAG + ":createAccount", "Failed with Exception", ccse);
            throw new RuntimeException();
        }
        MicrosoftStsAccount account = new MicrosoftStsAccount(idToken, clientInfo);
        account.setEnvironment(this.getIssuerCacheIdentifierFromTokenEndpoint());
        return account;
    }

    @Override
    public MicrosoftStsAuthorizationRequest.Builder createAuthorizationRequestBuilder() {
        String methodName = ":createAuthorizationRequestBuilder";
        Logger.info(TAG + ":createAuthorizationRequestBuilder", "Creating AuthorizationRequestBuilder...");
        MicrosoftStsAuthorizationRequest.Builder builder = new MicrosoftStsAuthorizationRequest.Builder();
        builder.setAuthority(((MicrosoftStsOAuth2Configuration)this.mConfig).getAuthorityUrl());
        if (((MicrosoftStsOAuth2Configuration)this.mConfig).getSlice() != null) {
            Logger.info(TAG + ":createAuthorizationRequestBuilder", "Setting slice params...");
            builder.setSlice(((MicrosoftStsOAuth2Configuration)this.mConfig).getSlice());
        }
        Map<String, String> platformParameters = Device.getPlatformIdParameters();
        builder.setLibraryName(platformParameters.get("x-client-SKU"));
        builder.setLibraryVersion(platformParameters.get("x-client-Ver"));
        builder.setFlightParameters(((MicrosoftStsOAuth2Configuration)this.mConfig).getFlightParameters());
        builder.setMultipleCloudAware(((MicrosoftStsOAuth2Configuration)this.mConfig).getMultipleCloudsSupported());
        return builder;
    }

    @Override
    public MicrosoftStsAuthorizationRequest.Builder createAuthorizationRequestBuilder(@Nullable IAccountRecord account) {
        String methodName = ":createAuthorizationRequestBuilder";
        Logger.info(TAG + ":createAuthorizationRequestBuilder", "Creating AuthorizationRequestBuilder");
        MicrosoftStsAuthorizationRequest.Builder builder = this.createAuthorizationRequestBuilder();
        if (null != account) {
            String homeAccountId = account.getHomeAccountId();
            Pair<String, String> uidUtidPair = StringUtil.getTenantInfo(homeAccountId);
            if (!StringExtensions.isNullOrBlank((String)uidUtidPair.first) && !StringExtensions.isNullOrBlank((String)uidUtidPair.second)) {
                builder.setUid((String)uidUtidPair.first);
                builder.setUtid((String)uidUtidPair.second);
                Logger.infoPII(TAG + ":createAuthorizationRequestBuilder", "Builder w/ uid: [" + (String)uidUtidPair.first + "]");
                Logger.infoPII(TAG + ":createAuthorizationRequestBuilder", "Builder w/ utid: [" + (String)uidUtidPair.second + "]");
            }
        }
        return builder;
    }

    @Override
    public MicrosoftStsTokenRequest createTokenRequest(@NonNull MicrosoftStsAuthorizationRequest request, @NonNull MicrosoftStsAuthorizationResponse response) {
        String methodName = ":createTokenRequest";
        Logger.verbose(TAG + ":createTokenRequest", "Creating TokenRequest...");
        if (((MicrosoftStsOAuth2Configuration)this.mConfig).getMultipleCloudsSupported() || request.getMultipleCloudAware().booleanValue()) {
            Logger.verbose(TAG, "get cloud specific authority based on authorization response.");
            this.setTokenEndpoint(this.getCloudSpecificTokenEndpoint(request, response));
        }
        MicrosoftStsTokenRequest tokenRequest = new MicrosoftStsTokenRequest();
        tokenRequest.setCodeVerifier(request.getPkceChallenge().getCodeVerifier());
        tokenRequest.setCode(response.getCode());
        tokenRequest.setRedirectUri(request.getRedirectUri());
        tokenRequest.setClientId(request.getClientId());
        tokenRequest.setScope(request.getTokenScope());
        tokenRequest.setGrantType("authorization_code");
        try {
            tokenRequest.setCorrelationId(UUID.fromString((String)DiagnosticContext.getRequestContext().get("correlation_id")));
        }
        catch (IllegalArgumentException ex) {
            Logger.error("MicrosoftSTSOAuth2Strategy", "Correlation id on diagnostic context is not a UUID.", ex);
        }
        return tokenRequest;
    }

    @Override
    public MicrosoftStsTokenRequest createRefreshTokenRequest() {
        String methodName = ":createRefreshTokenRequest";
        Logger.verbose(TAG + ":createRefreshTokenRequest", "Creating refresh token request");
        MicrosoftStsTokenRequest request = new MicrosoftStsTokenRequest();
        request.setGrantType("refresh_token");
        return request;
    }

    @Override
    protected void validateAuthorizationRequest(MicrosoftStsAuthorizationRequest request) {
    }

    @Override
    protected void validateTokenRequest(MicrosoftStsTokenRequest request) {
    }

    @Override
    protected HttpResponse performTokenRequest(MicrosoftStsTokenRequest request) throws IOException, ClientException {
        String methodName = ":performTokenRequest";
        HttpResponse response = super.performTokenRequest(request);
        if (response.getStatusCode() == 401 && response.getHeaders() != null && response.getHeaders().containsKey("WWW-Authenticate")) {
            Logger.info(TAG + ":performTokenRequest", "Receiving device certificate challenge request. ");
            return this.performPKeyAuthRequest(response, request);
        }
        return response;
    }

    private HttpResponse performPKeyAuthRequest(@NonNull HttpResponse response, @NonNull MicrosoftStsTokenRequest request) throws IOException, ClientException {
        String methodName = "#performPkeyAuthRequest";
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(request);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("client-request-id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        headers.putAll(Device.getPlatformIdParameters());
        String challengeHeader = response.getHeaders().get("WWW-Authenticate").get(0);
        Logger.info(TAG + "#performPkeyAuthRequest", "Device certificate challenge request. ");
        Logger.infoPII(TAG + "#performPkeyAuthRequest", "Challenge header: " + challengeHeader);
        try {
            PKeyAuthChallengeFactory factory = new PKeyAuthChallengeFactory();
            URL authority = StringExtensions.getUrl(this.mTokenEndpoint);
            PKeyAuthChallenge pkeyAuthChallenge = factory.getPKeyAuthChallenge(challengeHeader, authority.toString());
            headers.putAll(PKeyAuthChallengeHandler.getChallengeHeader(pkeyAuthChallenge));
            headers.putAll(EstsTelemetry.getInstance().getTelemetryHeaders());
            HttpResponse pkeyAuthResponse = HttpRequest.sendPost(authority, headers, requestBody.getBytes("UTF-8"), "application/x-www-form-urlencoded");
            return pkeyAuthResponse;
        }
        catch (UnsupportedEncodingException exception) {
            throw new ClientException("unsupported_encoding", "Unsupported encoding", exception);
        }
    }

    @Override
    @NonNull
    protected TokenResult getTokenResultFromHttpResponse(@NonNull HttpResponse response) {
        Map<String, List<String>> responseHeaders;
        List<String> cliTelemValues;
        String methodName = ":getTokenResultFromHttpResponse";
        Logger.verbose(TAG + ":getTokenResultFromHttpResponse", "Getting TokenResult from HttpResponse...");
        MicrosoftStsTokenResponse tokenResponse = null;
        TokenErrorResponse tokenErrorResponse = null;
        if (response.getStatusCode() >= 400) {
            tokenErrorResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), MicrosoftTokenErrorResponse.class);
            tokenErrorResponse.setStatusCode(response.getStatusCode());
            if (null != response.getHeaders()) {
                tokenErrorResponse.setResponseHeadersJson(HeaderSerializationUtil.toJson(response.getHeaders()));
            }
            tokenErrorResponse.setResponseBody(response.getBody());
        } else {
            tokenResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), MicrosoftStsTokenResponse.class);
        }
        TokenResult result = new TokenResult(tokenResponse, tokenErrorResponse);
        BaseController.logResult(TAG, result);
        if (null != response.getHeaders() && null != (cliTelemValues = (responseHeaders = response.getHeaders()).get("x-ms-clitelem")) && !cliTelemValues.isEmpty()) {
            String cliTelemHeader = cliTelemValues.get(0);
            CliTelemInfo cliTelemInfo = CliTelemInfo.fromXMsCliTelemHeader(cliTelemHeader);
            result.setCliTelemInfo(cliTelemInfo);
            if (null != tokenResponse && null != cliTelemInfo) {
                tokenResponse.setSpeRing(cliTelemInfo.getSpeRing());
                tokenResponse.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
                tokenResponse.setCliTelemErrorCode(cliTelemInfo.getServerErrorCode());
                tokenResponse.setCliTelemSubErrorCode(cliTelemInfo.getServerSubErrorCode());
            }
        }
        return result;
    }

    private String buildCloudSpecificTokenEndpoint(@NonNull MicrosoftStsAuthorizationResponse response) {
        if (!StringUtil.isEmpty(response.getCloudInstanceHostName())) {
            String updatedTokenEndpoint = Uri.parse((String)this.mTokenEndpoint).buildUpon().authority(response.getCloudInstanceHostName()).build().toString();
            return updatedTokenEndpoint;
        }
        return this.mTokenEndpoint;
    }

    private String getCloudSpecificTokenEndpoint(MicrosoftAuthorizationRequest request, MicrosoftAuthorizationResponse response) {
        String tokenEndpoint;
        String methodName = ":getCloudSpecificTokenEndpoint";
        if (StringUtil.isEmpty(response.getCloudInstanceHostName())) {
            return this.mTokenEndpoint;
        }
        OpenIdProviderConfiguration openIdConfig = ((MicrosoftStsOAuth2Configuration)this.mConfig).getOpenIdWellKnownConfig(response.getCloudInstanceHostName(), request.getAuthority().getPath());
        if (openIdConfig != null && openIdConfig.getTokenEndpoint() != null) {
            tokenEndpoint = openIdConfig.getTokenEndpoint();
        } else {
            Logger.verbose(TAG + ":getCloudSpecificTokenEndpoint", "Token Endpoint not obtained from well known config. Building token endpoint manually.");
            tokenEndpoint = this.buildCloudSpecificTokenEndpoint((MicrosoftStsAuthorizationResponse)response);
        }
        return tokenEndpoint;
    }
}

