/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.text.TextUtils;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.SdkType;

public class BrokerAcquireTokenOperationParameters
extends AcquireTokenOperationParameters {
    private String mCallerPackageName;
    private int mCallerUId;
    private String mCallerAppVersion;
    private boolean mShouldResolveInterrupt;
    private RequestType mRequestType = RequestType.REGULAR;

    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public void setCallerPackageName(String callerPackageName) {
        this.mCallerPackageName = callerPackageName;
    }

    public int getCallerUId() {
        return this.mCallerUId;
    }

    public void setCallerUId(int callerUId) {
        this.mCallerUId = callerUId;
    }

    public String getCallerAppVersion() {
        return this.mCallerAppVersion;
    }

    public void setCallerAppVersion(String callerAppVersion) {
        this.mCallerAppVersion = callerAppVersion;
    }

    public RequestType getRequestType() {
        return this.mRequestType;
    }

    public void setRequestType(RequestType requestType) {
        this.mRequestType = requestType;
    }

    public boolean getShouldResolveInterrupt() {
        return this.mShouldResolveInterrupt;
    }

    public void setShouldResolveInterrupt(boolean shouldResolveInterrupt) {
        this.mShouldResolveInterrupt = shouldResolveInterrupt;
    }

    @Override
    public void validate() throws ArgumentException {
        super.validate();
        if (this.getAuthority() == null) {
            throw new ArgumentException("acquireToken", "mAuthority", "Authority Url is not set");
        }
        if (this.getScopes() == null || this.getScopes().isEmpty()) {
            throw new ArgumentException("acquireToken", "mScopes", "Scope or resource is not set");
        }
        if (TextUtils.isEmpty((CharSequence)this.getClientId())) {
            throw new ArgumentException("acquireToken", "mClientId", "Client Id is not set");
        }
        if (!this.isRequestFromBroker()) {
            if (this.mCallerUId == 0) {
                throw new ArgumentException("acquireToken", "mCallerUId", "Caller Uid is not set");
            }
            if (TextUtils.isEmpty((CharSequence)this.mCallerPackageName)) {
                throw new ArgumentException("acquireToken", "mCallerPackageName", "Caller package name is not set");
            }
            if (!(this.getTokenCache() instanceof BrokerOAuth2TokenCache)) {
                throw new ArgumentException("acquireToken", "AcquireTokenSilentOperationParameters", "OAuth2Cache not an instance of BrokerOAuth2TokenCache");
            }
            if (SdkType.MSAL == this.getSdkType() && !BrokerValidator.isValidBrokerRedirect(this.getRedirectUri(), this.getAppContext(), this.getCallerPackageName())) {
                throw new ArgumentException("acquireToken", "mRedirectUri", "The redirect URI doesn't match the uri generated with caller package name and signature");
            }
        }
    }

    public boolean isRequestFromBroker() {
        return this.mRequestType == RequestType.BROKER_RT_REQUEST || this.mRequestType == RequestType.RESOLVE_INTERRUPT;
    }

    public static enum RequestType {
        REGULAR,
        BROKER_RT_REQUEST,
        RESOLVE_INTERRUPT;

    }
}

