/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.eststelemetry.IRequestTelemetryCache;
import com.microsoft.identity.common.internal.eststelemetry.RequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.Schema;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.Map;

public class SharedPreferencesLastRequestTelemetryCache
implements IRequestTelemetryCache {
    private static final String TAG = SharedPreferencesLastRequestTelemetryCache.class.getSimpleName();
    private final ISharedPreferencesFileManager mSharedPreferencesFileManager;

    SharedPreferencesLastRequestTelemetryCache(@NonNull ISharedPreferencesFileManager sharedPreferencesFileManager) {
        Logger.verbose(TAG, "Init: " + TAG);
        this.mSharedPreferencesFileManager = sharedPreferencesFileManager;
    }

    ISharedPreferencesFileManager getSharedPreferencesFileManager() {
        return this.mSharedPreferencesFileManager;
    }

    @Override
    @Nullable
    public synchronized RequestTelemetry getRequestTelemetryFromCache() {
        String methodName = ":getRequestTelemetryFromCache";
        Map<String, String> data = this.mSharedPreferencesFileManager.getAll();
        if (data == null || data.isEmpty()) {
            Logger.verbose(TAG + ":getRequestTelemetryFromCache", "Last Request telemetry not found in cache. ");
            return null;
        }
        String schemaVersion = data.get("schema_version");
        RequestTelemetry lastRequestTelemetry = new RequestTelemetry(schemaVersion, false);
        String[] lastCommonFields = Schema.getCommonFields(false);
        String[] lastPlatformFields = Schema.getPlatformFields(false);
        for (String key : lastCommonFields) {
            lastRequestTelemetry.putTelemetry(key, data.get(key));
        }
        for (String key : lastPlatformFields) {
            lastRequestTelemetry.putTelemetry(key, data.get(key));
        }
        return lastRequestTelemetry;
    }

    @Override
    public synchronized void saveRequestTelemetryToCache(@NonNull RequestTelemetry requestTelemetry) {
        Logger.verbose(TAG, "Saving Request Telemetry to cache...");
        this.mSharedPreferencesFileManager.putString("schema_version", "1");
        this.saveTelemetryDataToCache(requestTelemetry.getCommonTelemetry());
        this.saveTelemetryDataToCache(requestTelemetry.getPlatformTelemetry());
    }

    private synchronized void saveTelemetryDataToCache(@NonNull Map<String, String> data) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String cacheKey = entry.getKey();
            String cacheValue = entry.getValue();
            if (TextUtils.isEmpty((CharSequence)cacheKey) || TextUtils.isEmpty((CharSequence)cacheValue)) continue;
            this.mSharedPreferencesFileManager.putString(cacheKey, cacheValue);
        }
    }

    @Override
    public synchronized void clearAll() {
        Logger.info(TAG, "Clearing all SharedPreferences entries...");
        this.mSharedPreferencesFileManager.clear();
        Logger.info(TAG, "SharedPreferences cleared.");
    }
}

