/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.Arrays;

public class Schema {
    public static final String SCHEMA_VERSION_KEY = "schema_version";
    public static final String CURRENT_SCHEMA_VERSION = "1";
    public static final String CURRENT_REQUEST_HEADER_NAME = "x-client-current-telemetry";
    public static final String LAST_REQUEST_HEADER_NAME = "x-client-last-telemetry";
    private static final String[] currentRequestCommonFields = new String[]{"Microsoft.MSAL.api_id", "Microsoft.MSAL.force_refresh"};
    private static final String[] currentRequestPlatformFields = new String[]{"Microsoft.MSAL.account_status", "Microsoft.MSAL.id_token_status", "Microsoft.MSAL.at_status", "Microsoft.MSAL.rt_status", "Microsoft.MSAL.frt_status", "Microsoft.MSAL.mrrt_status"};
    private static final String[] lastRequestCommonFields = new String[]{"Microsoft.MSAL.api_id", "Microsoft.MSAL.correlation_id", "Microsoft.MSAL.api_error_code"};
    private static final String[] lastRequestPlatformFields = new String[0];

    private static boolean isCurrentCommonField(String key) {
        return Arrays.asList(currentRequestCommonFields).contains(key);
    }

    private static boolean isLastCommonField(String key) {
        return Arrays.asList(lastRequestCommonFields).contains(key);
    }

    private static boolean isCurrentPlatformField(String key) {
        return Arrays.asList(currentRequestPlatformFields).contains(key);
    }

    private static boolean isLastPlatformField(String key) {
        return Arrays.asList(lastRequestPlatformFields).contains(key);
    }

    private static String[] getCurrentRequestCommonFields() {
        return currentRequestCommonFields;
    }

    private static String[] getCurrentRequestPlatformFields() {
        return currentRequestPlatformFields;
    }

    private static String[] getLastRequestCommonFields() {
        return lastRequestCommonFields;
    }

    private static String[] getLastRequestPlatformFields() {
        return lastRequestPlatformFields;
    }

    static String[] getCommonFields(boolean isCurrent) {
        return isCurrent ? Schema.getCurrentRequestCommonFields() : Schema.getLastRequestCommonFields();
    }

    static String[] getPlatformFields(boolean isCurrent) {
        return isCurrent ? Schema.getCurrentRequestPlatformFields() : Schema.getLastRequestPlatformFields();
    }

    static boolean isCommonField(String key, boolean isCurrent) {
        return isCurrent ? Schema.isCurrentCommonField(key) : Schema.isLastCommonField(key);
    }

    static boolean isPlatformField(String key, boolean isCurrent) {
        return isCurrent ? Schema.isCurrentPlatformField(key) : Schema.isLastPlatformField(key);
    }

    static String getSchemaCompliantStringFromBoolean(boolean val) {
        return val ? CURRENT_SCHEMA_VERSION : "0";
    }

    static String getSchemaCompliantString(String s) {
        if (StringUtil.isEmpty(s)) {
            return "";
        }
        if (s.equals("true")) {
            return CURRENT_SCHEMA_VERSION;
        }
        if (s.equals("false")) {
            return "0";
        }
        return s;
    }

    public static final class Value {
        public static final String TRUE = "1";
        public static final String FALSE = "0";
        public static final String EMPTY = "";
    }

    public static final class Key {
        public static final String API_ID = "Microsoft.MSAL.api_id";
        public static final String FORCE_REFRESH = "Microsoft.MSAL.force_refresh";
        public static final String CORRELATION_ID = "Microsoft.MSAL.correlation_id";
        public static final String ERROR_CODE = "Microsoft.MSAL.api_error_code";
        public static final String ACCOUNT_STATUS = "Microsoft.MSAL.account_status";
        public static final String ID_TOKEN_STATUS = "Microsoft.MSAL.id_token_status";
        public static final String AT_STATUS = "Microsoft.MSAL.at_status";
        public static final String RT_STATUS = "Microsoft.MSAL.rt_status";
        public static final String FRT_STATUS = "Microsoft.MSAL.frt_status";
        public static final String MRRT_STATUS = "Microsoft.MSAL.mrrt_status";
    }
}

