/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isEmpty(String message) {
        return message == null || message.trim().length() == 0;
    }

    public static String convertSetToString(Set<String> inputSet, String delimiter) {
        if (inputSet == null || inputSet.isEmpty() || delimiter == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = inputSet.iterator();
        stringBuilder.append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(delimiter);
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public static String join(char delimiter, List<String> toJoin) {
        StringBuilder builder = new StringBuilder();
        char tempDelimiter = '\u0000';
        for (String s : toJoin) {
            if (tempDelimiter != '\u0000') {
                builder.append(tempDelimiter);
            }
            tempDelimiter = delimiter;
            builder.append(s);
        }
        return builder.toString();
    }
}

