/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BrowserSelector {
    private static final String TAG = BrowserSelector.class.getSimpleName();
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final String CUSTOM_TABS_SERVICE_ACTION = "android.support.customtabs.action.CustomTabsService";

    public static Browser select(Context context) throws ClientException {
        List<Browser> allBrowsers = BrowserSelector.getAllBrowsers(context);
        if (!allBrowsers.isEmpty()) {
            Logger.verbose(TAG, "Select the browser to launch.");
            Logger.verbosePII(TAG, "Browser's package name: " + allBrowsers.get(0).getPackageName() + " version: " + allBrowsers.get(0).getVersion());
            return allBrowsers.get(0);
        }
        Logger.error(TAG, "No available browser installed on the device.", null);
        throw new ClientException("No available browser installed on the device.", "No available browser installed on the device.");
    }

    public static List<Browser> getAllBrowsers(Context context) {
        Intent BROWSER_INTENT = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        ArrayList<Browser> browserList = new ArrayList<Browser>();
        PackageManager pm = context.getPackageManager();
        int queryFlag = 64;
        if (Build.VERSION.SDK_INT >= 23) {
            queryFlag |= 0x10000;
        }
        List resolvedActivityList = pm.queryIntentActivities(BROWSER_INTENT, queryFlag);
        for (ResolveInfo info : resolvedActivityList) {
            if (!BrowserSelector.isFullBrowser(info)) continue;
            try {
                PackageInfo packageInfo = pm.getPackageInfo(info.activityInfo.packageName, 64);
                if (BrowserSelector.isCustomTabsServiceSupported(context, packageInfo)) {
                    browserList.add(new Browser(packageInfo, true));
                    continue;
                }
                browserList.add(new Browser(packageInfo, false));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        Logger.verbose(TAG, null, "Found " + browserList.size() + " browsers.");
        return browserList;
    }

    private static boolean isCustomTabsServiceSupported(@NonNull Context context, @NonNull PackageInfo packageInfo) {
        Intent serviceIntent = new Intent(CUSTOM_TABS_SERVICE_ACTION);
        serviceIntent.setPackage(packageInfo.packageName);
        List resolveInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
        return resolveInfos != null && !resolveInfos.isEmpty();
    }

    private static boolean isFullBrowser(ResolveInfo resolveInfo) {
        if (!resolveInfo.filter.hasAction("android.intent.action.VIEW") || !resolveInfo.filter.hasCategory("android.intent.category.BROWSABLE") || resolveInfo.filter.schemesIterator() == null) {
            return false;
        }
        if (resolveInfo.filter.authoritiesIterator() != null) {
            return false;
        }
        boolean supportsHttp = false;
        boolean supportsHttps = false;
        Iterator schemeIter = resolveInfo.filter.schemesIterator();
        while (schemeIter.hasNext()) {
            String scheme = (String)schemeIter.next();
            if (!(supportsHttp |= SCHEME_HTTP.equals(scheme)) || !(supportsHttps |= SCHEME_HTTPS.equals(scheme))) continue;
            return true;
        }
        return false;
    }
}

