/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.content.Intent;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationErrorResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.HashMap;

public class MicrosoftStsAuthorizationResultFactory
extends AuthorizationResultFactory<MicrosoftStsAuthorizationResult, MicrosoftStsAuthorizationRequest> {
    private static final String TAG = MicrosoftStsAuthorizationResultFactory.class.getSimpleName();
    public static final String MSSTS_AUTHORIZATION_FINAL_URL = "com.microsoft.identity.client.final.url";

    @Override
    public MicrosoftStsAuthorizationResult createAuthorizationResult(int resultCode, Intent data, MicrosoftStsAuthorizationRequest request) {
        MicrosoftStsAuthorizationResult result;
        if (data == null) {
            return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "Received null intent");
        }
        switch (resultCode) {
            case 2001: {
                Logger.verbose(TAG, null, "User cancel the authorization request in UI.");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.USER_CANCEL, "user_cancelled", "User pressed device back button to cancel the flow.");
                break;
            }
            case 2003: {
                String url = data.getStringExtra(MSSTS_AUTHORIZATION_FINAL_URL);
                result = this.parseUrlAndCreateAuthorizationResponse(url, request.getState());
                break;
            }
            case 2002: {
                String error = data.getStringExtra("com.microsoft.aad.adal:BrowserErrorCode");
                String errorDescription = data.getStringExtra("com.microsoft.aad.adal:BrowserErrorMessage");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, error, errorDescription);
                break;
            }
            default: {
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "Unknown error", "Unknown result code returned ");
            }
        }
        return result;
    }

    private MicrosoftStsAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, String error, String errorDescription) {
        Logger.info(TAG, "Error is returned from webview redirect");
        Logger.infoPII(TAG, "error: " + error + " errorDescription: " + errorDescription);
        MicrosoftStsAuthorizationErrorResponse errorResponse = new MicrosoftStsAuthorizationErrorResponse(error, errorDescription);
        return new MicrosoftStsAuthorizationResult(authStatus, errorResponse);
    }

    private MicrosoftStsAuthorizationResult parseUrlAndCreateAuthorizationResponse(String url, String requestStateParameter) {
        MicrosoftStsAuthorizationResult result;
        HashMap<String, String> urlParameters;
        HashMap<String, String> hashMap = urlParameters = StringUtil.isEmpty(url) ? null : StringExtensions.getUrlParameters(url);
        if (urlParameters == null || urlParameters.isEmpty()) {
            Logger.warn(TAG, "Invalid server response, empty query string from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response.");
        } else {
            result = urlParameters.containsKey("code") ? this.validateAndCreateAuthorizationResult(urlParameters.get("code"), urlParameters.get("state"), requestStateParameter) : (urlParameters.containsKey("error") ? this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, urlParameters.get("error"), urlParameters.get("error_description")) : this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response."));
        }
        return result;
    }

    private MicrosoftStsAuthorizationResult validateAndCreateAuthorizationResult(String code, String state, String requestStateParameter) {
        MicrosoftStsAuthorizationResult result;
        if (StringUtil.isEmpty(state)) {
            Logger.warn(TAG, "State parameter is not returned from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "State is not returned");
        } else if (StringUtil.isEmpty(requestStateParameter) || !requestStateParameter.equals(state)) {
            Logger.warn(TAG, "State parameter returned from the redirect is not same as the one sent in request.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "Returned state from authorize endpoint is not the same as the one sent");
        } else {
            Logger.info(TAG, "Auth code is successfully returned from webview redirect.");
            MicrosoftStsAuthorizationResponse authResponse = new MicrosoftStsAuthorizationResponse(code, state);
            result = new MicrosoftStsAuthorizationResult(AuthorizationStatus.SUCCESS, authResponse);
        }
        return result;
    }
}

