/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.support.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import java.util.Map;

public class MicrosoftStsAccount
extends MicrosoftAccount {
    private static final String TAG = MicrosoftStsAccount.class.getSimpleName();

    public MicrosoftStsAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        super(idToken, clientInfo);
        Logger.verbose(TAG, "Init: " + TAG);
    }

    @Override
    public String getAuthorityType() {
        return "MSSTS";
    }

    @Override
    protected String getDisplayableId(Map<String, String> claims) {
        if (!StringExtensions.isNullOrBlank(claims.get("preferred_username"))) {
            return claims.get("preferred_username");
        }
        if (!StringExtensions.isNullOrBlank(claims.get("email"))) {
            return claims.get("email");
        }
        Logger.warn(TAG, "The preferred username is not returned from the IdToken.");
        return "Missing from the token response";
    }
}

