/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft;

import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import android.util.Pair;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.PkceChallenge;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class MicrosoftAuthorizationRequest<T extends MicrosoftAuthorizationRequest<T>>
extends AuthorizationRequest<T> {
    private static final long serialVersionUID = 6873634931996113294L;
    private static final String TAG = MicrosoftAuthorizationRequest.class.getSimpleName();
    private transient URL mAuthority;
    @SerializedName(value="login_hint")
    private String mLoginHint;
    @SerializedName(value="client-request-id")
    private UUID mCorrelationId;
    @SerializedName(value="pkceChallenge")
    private PkceChallenge mPkceChallenge;
    @SerializedName(value="x-client-Ver")
    private String mLibraryVersion;
    @SerializedName(value="x-client-SKU")
    private String mLibraryName;
    @SerializedName(value="x-client-OS")
    private String mDiagnosticOS;
    @SerializedName(value="x-client-CPU")
    private String mDiagnosticCPU;
    @SerializedName(value="x-client-DM")
    private String mDiagnosticDM;
    protected transient AzureActiveDirectorySlice mSlice;
    protected transient Map<String, String> mFlightParameters;

    protected MicrosoftAuthorizationRequest(Builder builder) {
        super(builder);
        this.mAuthority = builder.mAuthority;
        this.mLoginHint = builder.mLoginHint;
        this.mCorrelationId = builder.mCorrelationId;
        this.mPkceChallenge = PkceChallenge.newPkceChallenge();
        this.mState = MicrosoftAuthorizationRequest.generateEncodedState();
        if (builder.mSlice != null) {
            this.mSlice = builder.mSlice;
        }
        this.mFlightParameters = builder.mFlightParameters;
        this.mLibraryVersion = builder.mLibraryVersion;
        this.mLibraryName = builder.mLibraryName;
        this.mDiagnosticOS = String.valueOf(Build.VERSION.SDK_INT);
        this.mDiagnosticDM = Build.MODEL;
        if (Build.VERSION.SDK_INT < 21) {
            this.mDiagnosticCPU = Build.CPU_ABI;
        } else {
            String[] supportedABIs = Build.SUPPORTED_ABIS;
            if (supportedABIs != null && supportedABIs.length > 0) {
                this.mDiagnosticCPU = supportedABIs[0];
            }
        }
    }

    public URL getAuthority() {
        return this.mAuthority;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public UUID getCorrelationId() {
        return this.mCorrelationId;
    }

    public PkceChallenge getPkceChallenge() {
        return this.mPkceChallenge;
    }

    public String getLibraryVersion() {
        return this.mLibraryVersion;
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public String getDiagnosticOS() {
        return this.mDiagnosticOS;
    }

    public String getDiagnosticCPU() {
        return this.mDiagnosticCPU;
    }

    public String getDiagnosticDM() {
        return this.mDiagnosticDM;
    }

    public static String generateEncodedState() {
        String encodedState;
        UUID stateUUID1 = UUID.randomUUID();
        UUID stateUUID2 = UUID.randomUUID();
        String state = stateUUID1.toString() + "-" + stateUUID2.toString();
        try {
            encodedState = Base64.encodeToString((byte[])state.getBytes("UTF-8"), (int)11);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error generating encoded state parameter for Authorization Request", e);
        }
        return encodedState;
    }

    public static String decodeState(String encodedState) {
        if (StringUtil.isEmpty(encodedState)) {
            Logger.warn(TAG, "Decode state failed because the input state is empty.");
            return null;
        }
        byte[] stateBytes = Base64.decode((String)encodedState, (int)9);
        return new String(stateBytes, Charset.defaultCharset());
    }

    @Override
    public Uri getAuthorizationRequestAsHttpRequest() throws UnsupportedEncodingException {
        Uri.Builder uriBuilder = Uri.parse((String)this.getAuthorizationEndpoint()).buildUpon();
        for (Map.Entry<String, String> entry : ObjectMapper.serializeObjectHashMap(this).entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        if (null != this.getExtraQueryParams() && !this.getExtraQueryParams().isEmpty()) {
            for (Pair pair : this.getExtraQueryParams()) {
                uriBuilder.appendQueryParameter((String)pair.first, (String)pair.second);
            }
        }
        return uriBuilder.build();
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AuthorizationRequest.Builder<B> {
        private URL mAuthority;
        private PkceChallenge mPkceChallenge;
        private String mLibraryVersion;
        private String mLibraryName;
        private AzureActiveDirectorySlice mSlice;
        private Map<String, String> mFlightParameters = new HashMap<String, String>();

        public B setAuthority(URL authority) {
            this.mAuthority = authority;
            return (B)this.self();
        }

        public B setPkceChallenge(PkceChallenge pkceChallenge) {
            this.mPkceChallenge = pkceChallenge;
            return (B)this.self();
        }

        public B setLibraryVersion(String libraryVersion) {
            this.mLibraryVersion = libraryVersion;
            return (B)this.self();
        }

        public B setLibraryName(String libraryName) {
            this.mLibraryName = libraryName;
            return (B)this.self();
        }

        public B setSlice(AzureActiveDirectorySlice slice) {
            this.mSlice = slice;
            return (B)this.self();
        }

        public B setFlightParameters(Map<String, String> flightParameters) {
            this.mFlightParameters = flightParameters;
            return (B)this.self();
        }

        @Override
        public abstract B self();
    }
}

