/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.logging;

import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.ILoggerCallback;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class Logger {
    private static final String CUSTOM_LOG_ERROR = "Custom log failed to log message:%s";
    private static final Logger INSTANCE = new Logger();
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private LogLevel mLogLevel = LogLevel.VERBOSE;
    private ILoggerCallback mExternalLogger;
    private final Object mLock = new Object();
    private static boolean sAllowPii = false;
    private static boolean sAllowLogcat = false;

    public static Logger getInstance() {
        return INSTANCE;
    }

    public static void setAllowPii(boolean allowPii) {
        sAllowPii = allowPii;
    }

    public static void setAllowLogcat(boolean allowLogcat) {
        sAllowLogcat = allowLogcat;
    }

    public static boolean getAllowPii() {
        return sAllowPii;
    }

    public static boolean getAllowLogcat() {
        return sAllowLogcat;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalLogger(ILoggerCallback externalLogger) {
        Object object = this.mLock;
        synchronized (object) {
            this.mExternalLogger = externalLogger;
        }
    }

    public static void error(String tag, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, DiagnosticContext.getRequestContext().toJsonString(), errorMessage, exception, false);
    }

    public static void error(String tag, @Nullable String correlationID, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, correlationID, errorMessage, exception, false);
    }

    public static void errorPII(String tag, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, DiagnosticContext.getRequestContext().toJsonString(), errorMessage, exception, true);
    }

    public static void errorPII(String tag, @Nullable String correlationID, @Nullable String errorMessage, @Nullable Throwable exception) {
        Logger.getInstance().log(tag, LogLevel.ERROR, correlationID, errorMessage, exception, true);
    }

    public static void warn(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, DiagnosticContext.getRequestContext().toJsonString(), message, null, false);
    }

    public static void warn(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, correlationID, message, null, false);
    }

    public static void warnPII(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, DiagnosticContext.getRequestContext().toJsonString(), message, null, true);
    }

    public static void warnPII(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.WARN, correlationID, message, null, true);
    }

    public static void info(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, DiagnosticContext.getRequestContext().toJsonString(), message, null, false);
    }

    public static void info(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, correlationID, message, null, false);
    }

    public static void infoPII(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, DiagnosticContext.getRequestContext().toJsonString(), message, null, true);
    }

    public static void infoPII(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.INFO, correlationID, message, null, true);
    }

    public static void verbose(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, DiagnosticContext.getRequestContext().toJsonString(), message, null, false);
    }

    public static void verbose(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, correlationID, message, null, false);
    }

    public static void verbosePII(String tag, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, DiagnosticContext.getRequestContext().toJsonString(), message, null, true);
    }

    public static void verbosePII(String tag, @Nullable String correlationID, @Nullable String message) {
        Logger.getInstance().log(tag, LogLevel.VERBOSE, correlationID, message, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String tag, LogLevel logLevel, @Nullable String correlationID, @Nullable String message, @Nullable Throwable throwable, boolean containsPII) {
        if (logLevel.compareTo(this.mLogLevel) > 0) {
            return;
        }
        if (!sAllowPii && containsPII) {
            return;
        }
        String logMessage = this.formatMessage(correlationID, message, throwable);
        if (sAllowLogcat) {
            this.sendLogcatLogs(tag, logLevel, logMessage);
        }
        Object object = this.mLock;
        synchronized (object) {
            block9: {
                if (null != this.mExternalLogger) {
                    try {
                        this.mExternalLogger.log(tag, logLevel, logMessage, containsPII);
                    }
                    catch (Exception e) {
                        if (containsPII && !sAllowPii) break block9;
                        Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, logMessage));
                    }
                }
            }
        }
    }

    private String formatMessage(@Nullable String correlationID, @Nullable String message, @Nullable Throwable throwable) {
        String logMessage = StringExtensions.isNullOrBlank(message) ? "N/A" : message;
        return " [" + Logger.getUTCDateTimeAsString() + (StringExtensions.isNullOrBlank(correlationID) ? "] " : " - " + correlationID + "] ") + logMessage + " Android " + Build.VERSION.SDK_INT + (throwable == null ? "" : '\n' + Log.getStackTraceString((Throwable)throwable));
    }

    private static String getUTCDateTimeAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    private void sendLogcatLogs(String tag, LogLevel logLevel, String message) {
        switch (logLevel) {
            case ERROR: {
                Log.e((String)tag, (String)message);
                break;
            }
            case WARN: {
                Log.w((String)tag, (String)message);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)message);
                break;
            }
            case VERBOSE: {
                Log.v((String)tag, (String)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level");
            }
        }
    }

    public static enum LogLevel {
        ERROR,
        WARN,
        INFO,
        VERBOSE;

    }
}

