/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.logging;

import com.microsoft.identity.common.internal.logging.IRequestContext;
import com.microsoft.identity.common.internal.logging.RequestContext;

public final class DiagnosticContext {
    public static final String CORRELATION_ID = "correlation_id";
    private static final String THREAD_ID = "thread_id";
    private static final ThreadLocal<IRequestContext> REQUEST_CONTEXT_THREAD_LOCAL = new ThreadLocal<IRequestContext>(){

        @Override
        protected RequestContext initialValue() {
            RequestContext defaultRequestContext = new RequestContext();
            defaultRequestContext.put(DiagnosticContext.CORRELATION_ID, "UNSET");
            return defaultRequestContext;
        }
    };

    private DiagnosticContext() {
    }

    public static void setRequestContext(IRequestContext requestContext) {
        if (null == requestContext) {
            DiagnosticContext.clear();
            return;
        }
        requestContext.put(THREAD_ID, String.valueOf(Thread.currentThread().getId()));
        REQUEST_CONTEXT_THREAD_LOCAL.set(requestContext);
    }

    public static IRequestContext getRequestContext() {
        if (!DiagnosticContext.hasThreadId()) {
            DiagnosticContext.setThreadId();
        }
        return REQUEST_CONTEXT_THREAD_LOCAL.get();
    }

    private static void setThreadId() {
        REQUEST_CONTEXT_THREAD_LOCAL.get().put(THREAD_ID, String.valueOf(Thread.currentThread().getId()));
    }

    private static boolean hasThreadId() {
        return REQUEST_CONTEXT_THREAD_LOCAL.get().containsKey(THREAD_ID);
    }

    public static void clear() {
        REQUEST_CONTEXT_THREAD_LOCAL.remove();
    }
}

