/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AccountCredentialCache
implements IAccountCredentialCache {
    private static final String TAG = AccountCredentialCache.class.getSimpleName();
    public static final String DEFAULT_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES = "com.microsoft.identity.client.account_credential_cache";
    private static final AccountRecord EMPTY_ACCOUNT = new AccountRecord();
    private static final AccessTokenRecord EMPTY_AT = new AccessTokenRecord();
    private static final RefreshTokenRecord EMPTY_RT = new RefreshTokenRecord();
    private static final IdTokenRecord EMPTY_ID = new IdTokenRecord();
    private final ISharedPreferencesFileManager mSharedPreferencesFileManager;
    private final ICacheKeyValueDelegate mCacheValueDelegate;

    public AccountCredentialCache(@NonNull ICacheKeyValueDelegate accountCacheValueDelegate, @NonNull ISharedPreferencesFileManager sharedPreferencesFileManager) {
        Logger.verbose(TAG, "Init: " + TAG);
        this.mSharedPreferencesFileManager = sharedPreferencesFileManager;
        this.mCacheValueDelegate = accountCacheValueDelegate;
    }

    @Override
    public synchronized void saveAccount(@NonNull AccountRecord account) {
        Logger.verbose(TAG, "Saving Account...");
        Logger.verbose(TAG, "Account type: [" + account.getClass().getSimpleName() + "]");
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(account);
        Logger.verbosePII(TAG, "Generated cache key: [" + cacheKey + "]");
        String cacheValue = this.mCacheValueDelegate.generateCacheValue(account);
        this.mSharedPreferencesFileManager.putString(cacheKey, cacheValue);
    }

    @Override
    public synchronized void saveCredential(@NonNull Credential credential) {
        Logger.verbose(TAG, "Saving credential...");
        String cacheKey = this.mCacheValueDelegate.generateCacheKey(credential);
        Logger.verbosePII(TAG, "Generated cache key: [" + cacheKey + "]");
        String cacheValue = this.mCacheValueDelegate.generateCacheValue(credential);
        this.mSharedPreferencesFileManager.putString(cacheKey, cacheValue);
    }

    @Override
    public synchronized AccountRecord getAccount(@NonNull String cacheKey) {
        Logger.verbose(TAG, "Loading Account by key...");
        AccountRecord account = (AccountRecord)this.mCacheValueDelegate.fromCacheValue(this.mSharedPreferencesFileManager.getString(cacheKey), AccountRecord.class);
        if (null == account || EMPTY_ACCOUNT.equals(account)) {
            Logger.warn(TAG, "The returned Account was uninitialized. Removing...");
            this.mSharedPreferencesFileManager.remove(cacheKey);
            account = null;
        }
        return account;
    }

    @Override
    public synchronized Credential getCredential(@NonNull String cacheKey) {
        Class clazz;
        Logger.verbose(TAG, "getCredential()");
        Logger.verbosePII(TAG, "Using cache key: [" + cacheKey + "]");
        CredentialType type = this.getCredentialTypeForCredentialCacheKey(cacheKey);
        if (CredentialType.AccessToken == type) {
            clazz = AccessTokenRecord.class;
        } else if (CredentialType.RefreshToken == type) {
            clazz = RefreshTokenRecord.class;
        } else if (CredentialType.IdToken == type) {
            clazz = IdTokenRecord.class;
        } else {
            throw new RuntimeException("Credential type could not be resolved.");
        }
        Credential credential = (Credential)this.mCacheValueDelegate.fromCacheValue(this.mSharedPreferencesFileManager.getString(cacheKey), clazz);
        if (null == credential || AccessTokenRecord.class == clazz && EMPTY_AT.equals(credential) || RefreshTokenRecord.class == clazz && EMPTY_RT.equals(credential) || IdTokenRecord.class == clazz && EMPTY_ID.equals(credential)) {
            Logger.warn(TAG, "The returned Credential was uninitialized. Removing...");
            this.mSharedPreferencesFileManager.remove(cacheKey);
            credential = null;
        }
        return credential;
    }

    @NonNull
    private Map<String, AccountRecord> getAccountsWithKeys() {
        Logger.verbose(TAG, "Loading Accounts + keys...");
        Map<String, String> cacheValues = this.mSharedPreferencesFileManager.getAll();
        HashMap<String, AccountRecord> accounts = new HashMap<String, AccountRecord>();
        for (Map.Entry<String, String> cacheValue : cacheValues.entrySet()) {
            String cacheKey = cacheValue.getKey();
            if (!this.isAccount(cacheKey)) continue;
            AccountRecord account = (AccountRecord)this.mCacheValueDelegate.fromCacheValue(cacheValue.getValue().toString(), AccountRecord.class);
            accounts.put(cacheKey, account);
        }
        Logger.verbose(TAG, "Returning [" + accounts.size() + "] Accounts w/ keys...");
        return accounts;
    }

    @Override
    @NonNull
    public synchronized List<AccountRecord> getAccounts() {
        Logger.verbose(TAG, "Loading Accounts...(no arg)");
        Map<String, AccountRecord> allAccounts = this.getAccountsWithKeys();
        ArrayList<AccountRecord> accounts = new ArrayList<AccountRecord>(allAccounts.values());
        Logger.info(TAG, "Found [" + accounts.size() + "] Accounts...");
        return accounts;
    }

    @Override
    @NonNull
    public List<AccountRecord> getAccountsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @Nullable String realm) {
        Logger.verbose(TAG, "Loading Accounts...");
        boolean mustMatchOnHomeAccountId = !StringExtensions.isNullOrBlank(homeAccountId);
        boolean mustMatchOnEnvironment = !StringExtensions.isNullOrBlank(environment);
        boolean mustMatchOnRealm = !StringExtensions.isNullOrBlank(realm);
        Logger.verbose(TAG, "Account lookup filtered by home_account_id? [" + mustMatchOnHomeAccountId + "]");
        Logger.verbose(TAG, "Account lookup filtered by realm? [" + mustMatchOnRealm + "]");
        List<AccountRecord> allAccounts = this.getAccounts();
        ArrayList<AccountRecord> matchingAccounts = new ArrayList<AccountRecord>();
        for (AccountRecord account : allAccounts) {
            boolean matches = true;
            if (mustMatchOnHomeAccountId) {
                matches = homeAccountId.equalsIgnoreCase(account.getHomeAccountId());
            }
            if (mustMatchOnEnvironment) {
                boolean bl = matches = matches && environment.equalsIgnoreCase(account.getEnvironment());
            }
            if (mustMatchOnRealm) {
                boolean bl = matches = matches && realm.equalsIgnoreCase(account.getRealm());
            }
            if (!matches) continue;
            matchingAccounts.add(account);
        }
        Logger.info(TAG, "Found [" + matchingAccounts.size() + "] matching Accounts...");
        return matchingAccounts;
    }

    @NonNull
    private Map<String, Credential> getCredentialsWithKeys() {
        Logger.verbose(TAG, "Loading Credentials with keys...");
        Map<String, String> cacheValues = this.mSharedPreferencesFileManager.getAll();
        HashMap<String, Credential> credentials = new HashMap<String, Credential>();
        for (Map.Entry<String, String> cacheValue : cacheValues.entrySet()) {
            String cacheKey = cacheValue.getKey();
            if (!this.isCredential(cacheKey)) continue;
            Credential credential = (Credential)this.mCacheValueDelegate.fromCacheValue(cacheValue.getValue().toString(), this.credentialClassForType(cacheKey));
            credentials.put(cacheKey, credential);
        }
        Logger.verbose(TAG, "Loaded [" + credentials.size() + "] Credentials...");
        return credentials;
    }

    @Override
    @NonNull
    public synchronized List<Credential> getCredentials() {
        Logger.verbose(TAG, "Loading Credentials...");
        Map<String, Credential> allCredentials = this.getCredentialsWithKeys();
        ArrayList<Credential> creds = new ArrayList<Credential>(allCredentials.values());
        Logger.verbose(TAG, "Found [" + creds.size() + "] Credentials");
        return creds;
    }

    @Override
    @NonNull
    public List<Credential> getCredentialsFilteredBy(@Nullable String homeAccountId, @Nullable String environment, @NonNull CredentialType credentialType, @NonNull String clientId, @Nullable String realm, @Nullable String target) {
        Logger.verbose(TAG, "getCredentialsFilteredBy()");
        if (null == credentialType) {
            throw new IllegalArgumentException("Param [credentialType] cannot be null.");
        }
        if (StringExtensions.isNullOrBlank(clientId)) {
            throw new IllegalArgumentException("Param [clientId] cannot be null.");
        }
        boolean mustMatchOnEnvironment = !StringExtensions.isNullOrBlank(environment);
        boolean mustMatchOnHomeAccountId = !StringExtensions.isNullOrBlank(homeAccountId);
        boolean mustMatchOnRealm = !StringExtensions.isNullOrBlank(realm);
        boolean mustMatchOnTarget = !StringExtensions.isNullOrBlank(target);
        Logger.verbose(TAG, "Credential lookup filtered by home_account_id? [" + mustMatchOnHomeAccountId + "]");
        Logger.verbose(TAG, "Credential lookup filtered by realm? [" + mustMatchOnRealm + "]");
        Logger.verbose(TAG, "Credential lookup filtered by target? [" + mustMatchOnTarget + "]");
        Logger.verbose(TAG, "Loading Credentials...");
        List<Credential> allCredentials = this.getCredentials();
        ArrayList<Credential> matchingCredentials = new ArrayList<Credential>();
        for (Credential credential : allCredentials) {
            AccessTokenRecord accessToken;
            boolean matches = true;
            if (mustMatchOnHomeAccountId) {
                matches = homeAccountId.equalsIgnoreCase(credential.getHomeAccountId());
            }
            if (mustMatchOnEnvironment) {
                matches = matches && environment.equalsIgnoreCase(credential.getEnvironment());
            }
            matches = matches && credentialType.name().equalsIgnoreCase(credential.getCredentialType());
            boolean bl = matches = matches && clientId.equalsIgnoreCase(credential.getClientId());
            if (mustMatchOnRealm && credential instanceof AccessTokenRecord) {
                accessToken = (AccessTokenRecord)credential;
                boolean bl2 = matches = matches && realm.equalsIgnoreCase(accessToken.getRealm());
            }
            if (mustMatchOnTarget) {
                if (credential instanceof AccessTokenRecord) {
                    accessToken = (AccessTokenRecord)credential;
                    matches = matches && this.targetsIntersect(target, accessToken.getTarget());
                } else if (credential instanceof RefreshTokenRecord) {
                    RefreshTokenRecord refreshToken = (RefreshTokenRecord)credential;
                    matches = matches && this.targetsIntersect(target, refreshToken.getTarget());
                } else {
                    Logger.warn(TAG, "Query specified target-match, but no target to match.");
                }
            }
            if (!matches) continue;
            matchingCredentials.add(credential);
        }
        Logger.info(TAG, "Found [" + matchingCredentials.size() + "] matching Credentials...");
        return matchingCredentials;
    }

    private boolean targetsIntersect(@NonNull String targetToMatch, @NonNull String credentialTarget) {
        String splitCriteria = "\\s+";
        String[] targetToMatchArray = targetToMatch.split("\\s+");
        String[] credentialTargetArray = credentialTarget.split("\\s+");
        HashSet<String> soughtTargetSet = new HashSet<String>();
        HashSet<String> credentialTargetSet = new HashSet<String>();
        for (String target : targetToMatchArray) {
            soughtTargetSet.add(target.toLowerCase());
        }
        for (String target : credentialTargetArray) {
            credentialTargetSet.add(target.toLowerCase());
        }
        return credentialTargetSet.containsAll(soughtTargetSet);
    }

    @Override
    public boolean removeAccount(@NonNull AccountRecord accountToRemove) {
        Logger.info(TAG, "Removing Account...");
        if (null == accountToRemove) {
            throw new IllegalArgumentException("Param [accountToRemove] cannot be null.");
        }
        Logger.verbose(TAG, "Loading Accounts + keys...");
        Map<String, AccountRecord> accounts = this.getAccountsWithKeys();
        Logger.info(TAG, "Found [" + accounts.size() + "] Accounts...");
        boolean accountRemoved = false;
        for (Map.Entry<String, AccountRecord> entry : accounts.entrySet()) {
            Logger.infoPII(TAG, "Inspecting: [" + entry.getKey() + "]");
            IAccountRecord currentAccount = entry.getValue();
            if (!currentAccount.equals(accountToRemove)) continue;
            this.mSharedPreferencesFileManager.remove(entry.getKey());
            accountRemoved = true;
            break;
        }
        Logger.info(TAG, "Account was removed? [" + accountRemoved + "]");
        return accountRemoved;
    }

    @Override
    public boolean removeCredential(@NonNull Credential credentialToRemove) {
        Logger.info(TAG, "Removing Credential...");
        if (null == credentialToRemove) {
            throw new IllegalArgumentException("Param [credentialToRemove] cannot be null.");
        }
        Logger.verbose(TAG, "Loading Credentials + keys...");
        Map<String, Credential> credentials = this.getCredentialsWithKeys();
        Logger.info(TAG, "Found [" + credentials.size() + "] Credentials...");
        boolean credentialRemoved = false;
        for (Map.Entry<String, Credential> entry : credentials.entrySet()) {
            Logger.infoPII(TAG, "Inspecting: [" + entry.getKey() + "]");
            Credential currentCredential = entry.getValue();
            if (!currentCredential.equals(credentialToRemove)) continue;
            this.mSharedPreferencesFileManager.remove(entry.getKey());
            credentialRemoved = true;
            break;
        }
        Logger.info(TAG, "Credential was removed? [" + credentialRemoved + "]");
        return credentialRemoved;
    }

    @Override
    public void clearAll() {
        Logger.info(TAG, "Clearing all SharedPreferences entries...");
        this.mSharedPreferencesFileManager.clear();
        Logger.info(TAG, "SharedPreferences cleared.");
    }

    private Class<? extends Credential> credentialClassForType(@NonNull String cacheKey) {
        Logger.verbose(TAG, "Resolving class for key/CredentialType...");
        Logger.verbosePII(TAG, "Supplied key: [" + cacheKey + "]");
        CredentialType targetType = this.getCredentialTypeForCredentialCacheKey(cacheKey);
        Logger.verbose(TAG, "CredentialType matched: [" + (Object)((Object)targetType) + "]");
        Class credentialClass = null;
        switch (targetType) {
            case AccessToken: {
                credentialClass = AccessTokenRecord.class;
                break;
            }
            case RefreshToken: {
                credentialClass = RefreshTokenRecord.class;
                break;
            }
            case IdToken: {
                credentialClass = IdTokenRecord.class;
                break;
            }
            default: {
                Logger.warn(TAG, "Could not match CredentialType to class.Did you forget to update this method with a new type?");
                Logger.warnPII(TAG, "Sought key was: [" + cacheKey + "]");
            }
        }
        return credentialClass;
    }

    private CredentialType getCredentialTypeForCredentialCacheKey(@NonNull String cacheKey) {
        if (StringExtensions.isNullOrBlank(cacheKey)) {
            throw new IllegalArgumentException("Param [cacheKey] cannot be null.");
        }
        Logger.verbosePII(TAG, "Evaluating cache key for CredentialType [" + cacheKey + "]");
        HashSet<String> credentialTypesLowerCase = new HashSet<String>();
        for (String credentialTypeStr : CredentialType.valueSet()) {
            credentialTypesLowerCase.add(credentialTypeStr.toLowerCase(Locale.US));
        }
        Logger.info(TAG, "Comparing cache key to known types...");
        CredentialType type = null;
        for (String credentialTypeStr : credentialTypesLowerCase) {
            if (!cacheKey.contains("-" + credentialTypeStr + "-")) continue;
            Logger.info(TAG, "Cache key is a Credential type...");
            if (credentialTypeStr.equalsIgnoreCase(CredentialType.AccessToken.name())) {
                type = CredentialType.AccessToken;
                break;
            }
            if (credentialTypeStr.equalsIgnoreCase(CredentialType.RefreshToken.name())) {
                type = CredentialType.RefreshToken;
                break;
            }
            if (credentialTypeStr.equalsIgnoreCase(CredentialType.IdToken.name())) {
                type = CredentialType.IdToken;
                break;
            }
            Logger.warn(TAG, "Unexpected credential type.");
        }
        Logger.info(TAG, "Cache key was type: [" + type + "]");
        return type;
    }

    private boolean isAccount(@NonNull String cacheKey) {
        Logger.verbosePII(TAG, "Evaluating cache key: [" + cacheKey + "]");
        boolean isAccount = null == this.getCredentialTypeForCredentialCacheKey(cacheKey);
        Logger.info(TAG, "isAccount? [" + isAccount + "]");
        return isAccount;
    }

    private boolean isCredential(@NonNull String cacheKey) {
        Logger.verbosePII(TAG, "Evaluating cache key: [" + cacheKey + "]");
        boolean isCredential = null != this.getCredentialTypeForCredentialCacheKey(cacheKey);
        Logger.info(TAG, "isCredential? [" + isCredential + "]");
        return isCredential;
    }
}

