/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.Callback;
import com.microsoft.identity.common.internal.broker.CallbackExecutor;
import com.microsoft.identity.common.internal.broker.IMicrosoftAuthService;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class MicrosoftAuthServiceHandler {
    private static final String TAG = MicrosoftAuthServiceHandler.class.getSimpleName();
    private static final String MICROSOFT_AUTH_SERVICE_INTENT_FILTER = "com.microsoft.workaccount.brokeraccount.MicrosoftAuth";
    private static final String MICROSOFT_AUTH_SERVICE_CLASS_NAME = "com.microsoft.workaccount.brokeraccount.MicrosoftAuthService";
    private ConcurrentMap<MicrosoftAuthServiceConnection, CallbackExecutor<MicrosoftAuthServiceConnection>> mPendingConnections = new ConcurrentHashMap<MicrosoftAuthServiceConnection, CallbackExecutor<MicrosoftAuthServiceConnection>>();
    private static ExecutorService sThreadExecutor = Executors.newCachedThreadPool();
    private static final MicrosoftAuthServiceHandler sInstance = new MicrosoftAuthServiceHandler();

    private MicrosoftAuthServiceHandler() {
    }

    public static MicrosoftAuthServiceHandler getInstance() {
        return sInstance;
    }

    public Bundle getAuthToken(final Context context, final Bundle requestBundle) throws ClientException {
        String methodName = ":getAuthToken";
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> bundleResult = new AtomicReference<Object>(null);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        this.performAsyncCallOnBound(context, new Callback<MicrosoftAuthServiceConnection>(){

            @Override
            public void onSuccess(MicrosoftAuthServiceConnection result) {
                IMicrosoftAuthService authService = result.getMicrosoftAuthServiceProvider();
                try {
                    bundleResult.set(authService.acquireTokenSilently(MicrosoftAuthServiceHandler.this.prepareGetAuthTokenRequestData(context, requestBundle)));
                }
                catch (RemoteException remoteException) {
                    exception.set(remoteException);
                }
                countDownLatch.countDown();
            }

            @Override
            public void onError(Throwable throwable) {
                exception.set(throwable);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            exception.set(e);
        }
        Throwable throwable = exception.getAndSet(null);
        if (throwable != null) {
            if (throwable instanceof RemoteException) {
                Logger.error(TAG + ":getAuthToken", null, "Get error when trying to get token from broker. " + throwable.getMessage(), throwable);
                throw new ClientException("Broker application is not responding", throwable.getMessage(), throwable);
            }
            if (throwable instanceof InterruptedException) {
                Logger.error(TAG + ":getAuthToken", null, "The MicrosoftAuthService binding call is interrupted. " + throwable.getMessage(), throwable);
                throw new ClientException("Broker application is not responding", throwable.getMessage(), throwable);
            }
            Logger.error(TAG + ":getAuthToken", null, "Get error when trying to bind the MicrosoftAuthService. " + throwable.getMessage(), throwable);
            throw new ClientException("Broker application is not responding", throwable.getMessage(), throwable);
        }
        return bundleResult.getAndSet(null);
    }

    public Bundle getBrokerUsers(Context context) throws IOException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> userBundle = new AtomicReference<Object>(null);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        this.performAsyncCallOnBound(context, new Callback<MicrosoftAuthServiceConnection>(){

            @Override
            public void onSuccess(MicrosoftAuthServiceConnection connection) {
                IMicrosoftAuthService authService = connection.getMicrosoftAuthServiceProvider();
                try {
                    userBundle.set(authService.getBrokerUsers());
                }
                catch (RemoteException ex) {
                    exception.set(ex);
                }
                countDownLatch.countDown();
            }

            @Override
            public void onError(Throwable throwable) {
                exception.set(throwable);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            exception.set(e);
        }
        Throwable exceptionForRetrievingBrokerUsers = exception.getAndSet(null);
        if (exceptionForRetrievingBrokerUsers != null) {
            throw new IOException(exceptionForRetrievingBrokerUsers.getMessage(), exceptionForRetrievingBrokerUsers);
        }
        return userBundle.getAndSet(null);
    }

    public Bundle getCapabilities(Context context) throws ClientException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> capabilityBundle = new AtomicReference<Object>(null);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        this.performAsyncCallOnBound(context, new Callback<MicrosoftAuthServiceConnection>(){

            @Override
            public void onSuccess(MicrosoftAuthServiceConnection connection) {
                IMicrosoftAuthService authService = connection.getMicrosoftAuthServiceProvider();
                try {
                    capabilityBundle.set(authService.getCapabilities());
                }
                catch (RemoteException ex) {
                    exception.set(ex);
                }
                countDownLatch.countDown();
            }

            @Override
            public void onError(Throwable throwable) {
                exception.set(throwable);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            exception.set(e);
        }
        Throwable exceptionGetCapabilities = exception.getAndSet(null);
        if (exceptionGetCapabilities != null) {
            throw new ClientException("Could not get the capabilities", exceptionGetCapabilities.getMessage(), exceptionGetCapabilities);
        }
        return capabilityBundle.getAndSet(null);
    }

    public Intent getIntentForInteractiveRequest(Context context) throws ClientException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> bundleResult = new AtomicReference<Object>(null);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        this.performAsyncCallOnBound(context, new Callback<MicrosoftAuthServiceConnection>(){

            @Override
            public void onSuccess(MicrosoftAuthServiceConnection result) {
                IMicrosoftAuthService authService = result.getMicrosoftAuthServiceProvider();
                try {
                    bundleResult.set(authService.getIntentForInteractiveRequest());
                }
                catch (RemoteException remoteException) {
                    exception.set(remoteException);
                }
                countDownLatch.countDown();
            }

            @Override
            public void onError(Throwable throwable) {
                exception.set(throwable);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            exception.set(e);
        }
        Throwable throwable = exception.getAndSet(null);
        if (throwable != null) {
            if (throwable instanceof RemoteException) {
                Logger.error(TAG, null, "Get error when trying to get token from broker. " + throwable.getMessage(), throwable);
                throw new ClientException("Broker application is not responding", throwable.getMessage(), throwable);
            }
            if (throwable instanceof InterruptedException) {
                Logger.error(TAG, null, "The MicrosoftAuthService binding call is interrupted. " + throwable.getMessage(), throwable);
                throw new ClientException("Broker application is not responding", throwable.getMessage(), throwable);
            }
            Logger.error(TAG, "Didn't receive the activity to launch from broker. " + throwable.getMessage(), throwable);
            throw new ClientException("Broker application is not responding", "Didn't receive the activity to launch from broker: " + throwable.getMessage(), throwable);
        }
        return bundleResult.getAndSet(null);
    }

    public void removeAccounts(Context context) {
        String methodName = ":removeAccounts";
        this.performAsyncCallOnBound(context, new Callback<MicrosoftAuthServiceConnection>(){

            @Override
            public void onSuccess(MicrosoftAuthServiceConnection result) {
                try {
                    result.getMicrosoftAuthServiceProvider().removeAccounts();
                }
                catch (RemoteException remoteException) {
                    Logger.error(TAG + ":removeAccounts", null, remoteException.getMessage(), remoteException);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                Logger.error(TAG + ":removeAccounts", null, throwable.getMessage(), throwable);
            }
        });
    }

    private void performAsyncCallOnBound(final Context context, final Callback<MicrosoftAuthServiceConnection> callback) {
        this.bindToAuthService(context, new Callback<MicrosoftAuthServiceConnection>(){

            @Override
            public void onSuccess(final MicrosoftAuthServiceConnection result) {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    callback.onSuccess(result);
                    result.unBindService(context);
                } else {
                    sThreadExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(result);
                            result.unBindService(context);
                        }
                    });
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        });
    }

    private void bindToAuthService(Context context, Callback<MicrosoftAuthServiceConnection> callback) {
        String methodName = ":bindToAuthService";
        Logger.verbose(TAG + ":bindToAuthService", "Binding to MicrosoftAuthService for caller uid. ", "uid: " + Process.myUid());
        Intent authServiceToBind = this.getIntentForAuthService(context);
        MicrosoftAuthServiceConnection connection = new MicrosoftAuthServiceConnection();
        CallbackExecutor<MicrosoftAuthServiceConnection> callbackExecutor = new CallbackExecutor<MicrosoftAuthServiceConnection>(callback);
        this.mPendingConnections.put(connection, callbackExecutor);
        boolean serviceBound = context.bindService(authServiceToBind, (ServiceConnection)connection, 1);
        Logger.verbose(TAG + ":bindToAuthService", "The status for MicrosoftAuthService bindService call is: " + Boolean.valueOf(serviceBound));
        if (!serviceBound) {
            connection.unBindService(context);
            callback.onError(new ClientException("Failed to bind the service in broker app"));
        }
    }

    private Map<String, String> prepareGetAuthTokenRequestData(Context context, Bundle requestBundle) {
        Set requestBundleKeys = requestBundle.keySet();
        HashMap<String, String> requestData = new HashMap<String, String>();
        for (String key : requestBundleKeys) {
            if (key.equals("com.microsoft.aad.adal:RequestId") || key.equals("expiration.buffer")) {
                requestData.put(key, String.valueOf(requestBundle.getInt(key)));
                continue;
            }
            requestData.put(key, requestBundle.getString(key));
        }
        requestData.put("caller.info.package", context.getPackageName());
        return requestData;
    }

    private Intent getIntentForAuthService(Context context) {
        String currentActiveBrokerPackageName = this.getCurrentActiveBrokerPackageName(context);
        if (currentActiveBrokerPackageName == null || currentActiveBrokerPackageName.length() == 0) {
            return null;
        }
        Intent authServiceToBind = new Intent(MICROSOFT_AUTH_SERVICE_INTENT_FILTER);
        authServiceToBind.setPackage(currentActiveBrokerPackageName);
        authServiceToBind.setClassName(currentActiveBrokerPackageName, MICROSOFT_AUTH_SERVICE_CLASS_NAME);
        return authServiceToBind;
    }

    private String getCurrentActiveBrokerPackageName(Context context) {
        AuthenticatorDescription[] authenticators;
        for (AuthenticatorDescription authenticator : authenticators = AccountManager.get((Context)context).getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount")) continue;
            return authenticator.packageName;
        }
        return null;
    }

    private class MicrosoftAuthServiceConnection
    implements ServiceConnection {
        private IMicrosoftAuthService mMicrosoftAuthService;
        private boolean mBound;

        private MicrosoftAuthServiceConnection() {
        }

        public IMicrosoftAuthService getMicrosoftAuthServiceProvider() {
            return this.mMicrosoftAuthService;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            Logger.verbose(TAG, "MicrosoftAuthService is connected.");
            this.mMicrosoftAuthService = IMicrosoftAuthService.Stub.asInterface(service);
            this.mBound = true;
            CallbackExecutor callbackExecutor = (CallbackExecutor)MicrosoftAuthServiceHandler.this.mPendingConnections.remove(this);
            if (callbackExecutor != null) {
                callbackExecutor.onSuccess(this);
            } else {
                Logger.verbose(TAG, "No callback is found.");
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Logger.verbose(TAG, "MicrosoftAuthService is disconnected.");
            this.mBound = false;
        }

        public void unBindService(final Context context) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (MicrosoftAuthServiceConnection.this.mBound) {
                        try {
                            context.unbindService((ServiceConnection)MicrosoftAuthServiceConnection.this);
                        }
                        catch (IllegalArgumentException exception) {
                            Logger.error(TAG, null, "Unbind threw IllegalArgumentException", exception);
                        }
                        finally {
                            MicrosoftAuthServiceConnection.this.mBound = false;
                        }
                    }
                }
            });
        }
    }
}

