/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Process;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthServiceHandler;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationRequest;
import java.io.Serializable;

public class BrokerTokenProvider {
    private static final String TAG = BrokerTokenProvider.class.getSimpleName();

    public void acquireTokenInteractively(Activity activity, MicrosoftAuthorizationRequest request) throws ClientException {
        String methodName = ":acquireTokenInteractively";
        if (activity == null) {
            throw new ClientException("Android Context is null.");
        }
        Bundle requestBundle = this.getBrokerOptions(request, activity);
        Intent brokerIntent = MicrosoftAuthServiceHandler.getInstance().getIntentForInteractiveRequest((Context)activity);
        if (brokerIntent == null) {
            ClientException exception = new ClientException("Broker application is not responding", "Received null intent from broker interactive request.");
            Logger.error(TAG, "Received null intent from broker interactive request.", exception);
            throw exception;
        }
        brokerIntent.putExtras(requestBundle);
        brokerIntent.putExtra("com.microsoft.aadbroker.adal.broker.request", "com.microsoft.aadbroker.adal.broker.request");
        Logger.verbose(TAG + ":acquireTokenInteractively", "Calling activity. Pid:" + Process.myPid() + " tid:" + Process.myTid() + "uid:" + Process.myUid());
        activity.startActivityForResult(brokerIntent, 1001);
    }

    private Bundle getBrokerOptions(MicrosoftAuthorizationRequest request, Activity activity) {
        Bundle brokerOptions = new Bundle();
        brokerOptions.putString("account.authority", request.getAuthority().toString());
        brokerOptions.putString("account.redirect", request.getRedirectUri());
        brokerOptions.putString("account.clientid.key", request.getClientId());
        brokerOptions.putString("account.userinfo.userid", request.getLoginHint());
        brokerOptions.putString("account.login.hint", request.getLoginHint());
        brokerOptions.putString("account.name", request.getLoginHint());
        brokerOptions.putString("response_type", request.getResponseType());
        brokerOptions.putString("state", request.getState());
        brokerOptions.putString("scope", request.getScope());
        brokerOptions.putString("library_name", request.getLibraryName());
        brokerOptions.putString("library_version", request.getLibraryVersion());
        brokerOptions.putString("client_app_package_name", activity.getPackageName());
        if (request.getCorrelationId() != null) {
            brokerOptions.putString("account.correlationid", request.getCorrelationId().toString());
        }
        if (request.getPkceChallenge() != null) {
            brokerOptions.putSerializable("PkceChallenge", (Serializable)request.getPkceChallenge());
        }
        return brokerOptions;
    }
}

